/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.URILineError;
import java.util.ArrayList;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class XMLErrorHandler
extends DefaultHandler {
    private int errorCount = 0;
    private int warningCount = 0;
    private ArrayList problemList = new ArrayList();

    XMLErrorHandler() {
    }

    private void reportProblem(SAXParseException sAXParseException, int n) {
        this.problemList.add(new URILineError(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), n, sAXParseException.getMessage()));
    }

    public String getErrorSummary() {
        return "XML file contained " + this.errorCount + " error" + (this.errorCount == 1 ? "" : "s") + " and " + this.warningCount + " warning" + (this.warningCount == 1 ? "" : "s");
    }

    public int getProblemCount() {
        return this.errorCount + this.warningCount;
    }

    public String[] getProblemListText() {
        int n = this.errorCount + this.warningCount;
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < this.errorCount + this.warningCount) {
            stringArray[n2] = ((URILineError)this.problemList.get(n2)).getDescription();
            ++n2;
        }
        stringArray[n] = this.getErrorSummary();
        return stringArray;
    }

    public void error(SAXParseException sAXParseException) {
        ++this.errorCount;
        this.reportProblem(sAXParseException, 1);
    }

    public void fatalError(SAXParseException sAXParseException) {
        ++this.errorCount;
        this.reportProblem(sAXParseException, 2);
    }

    public void warning(SAXParseException sAXParseException) {
        ++this.warningCount;
        this.reportProblem(sAXParseException, 0);
    }
}

