/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.AWT;
import db.lib.ExceptionReporter;
import db.tools.EdgeSchemaFormatter;
import db.tools.ElementSchemaFormatter;
import db.tools.IndentedXMLFormatter;
import db.tools.TeXXMLFormatter;
import db.tools.XMLErrorHandler;
import db.tools.XMLTextFile;
import db.tools.XMLTextFileEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLTool
extends JApplet
implements ActionListener {
    private static int debug = 0;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu optionsMenu;
    private JMenuItem exitMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem newMenuItem;
    private JMenuItem parseMenuItem;
    private JMenuItem exportMenuItem;
    private ButtonGroup schemaButtonGroup;
    private JRadioButtonMenuItem noSchemaMenuItem;
    private JRadioButtonMenuItem useDTDMenuItem;
    private JRadioButtonMenuItem useXMLSchemaMenuItem;
    private ButtonGroup exportButtonGroup;
    private JRadioButtonMenuItem exportLatexMenuItem;
    private JRadioButtonMenuItem exportXMLMenuItem;
    private JRadioButtonMenuItem exportEdgeSchemaMenuItem;
    private JRadioButtonMenuItem exportElementSchemaMenuItem;
    private JCheckBoxMenuItem namespaceMenuItem;
    private JCheckBoxMenuItem validationMenuItem;
    private JButton stop;
    private JButton parse;
    private JButton translate;
    private XMLTextFile export = new XMLTextFile("Export Files", new String[]{"tex"});
    private XMLTextFile XML = new XMLTextFile("XML Files", new String[]{"xml"});
    private XMLTextFile XSLT = new XMLTextFile("XSLT Files", new String[]{"xsl"});
    private XMLTextFile transformedXML = new XMLTextFile("Transformed Files", new String[]{"txt", "xml", "html", "htm"});
    private XMLTextFile schema = new XMLTextFile("Schema Files", new String[]{"dtd", "xsd"});
    private XMLTextFileEditor text = new XMLTextFileEditor(this.XML);
    private String outFormatter = null;
    private String defaultCommand = "";
    private PrintStream XMLOutput = System.out;
    private JTextArea chatter;
    private volatile transient boolean running = false;
    private int xSize = 600;
    private int ySize = 250;
    private transient int line = 0;
    private boolean namespace = true;
    private boolean validation = true;
    private boolean noUI = false;
    private int schemaType = 1;
    private int viewMode = 0;
    private static final int VIEW_XML_INPUT = 0;
    private static final int VIEW_XML_OUTPUT = 1;
    private static final int VIEW_XSLT = 2;
    private static final int VIEW_SCHEMA = 3;
    private static final int VIEW_EXPORT = 4;
    private JComboBox viewModeBox;
    private int exportMode = 3;
    private static final int EXPORT_LATEX = 0;
    private static final int EXPORT_XML = 1;
    private static final int EXPORT_EDGE_SCHEMA = 2;
    private static final int EXPORT_ELEMENT_SCHEMA = 3;
    private JComboBox exportModeBox;
    private static TransformerFactory tFactory = TransformerFactory.newInstance();
    private ExceptionReporter er = new ExceptionReporter();

    public void createComponents() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.getAccessibleContext().setAccessibleDescription("File control");
        this.menuBar.add(this.fileMenu);
        this.newMenuItem = new JMenuItem("New", 78);
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 8));
        this.newMenuItem.getAccessibleContext().setAccessibleDescription("New document");
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem = new JMenuItem("Open", 79);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.openMenuItem.getAccessibleContext().setAccessibleDescription("Open a new file");
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem = new JMenuItem("Save", 83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.saveMenuItem.getAccessibleContext().setAccessibleDescription("Save the file");
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = new JMenuItem("SaveAs", 65);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.saveAsMenuItem.getAccessibleContext().setAccessibleDescription("Save the file under a new name");
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem = new JMenuItem("Exit", 88);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        this.exitMenuItem.getAccessibleContext().setAccessibleDescription("Exit the XML Tool");
        this.fileMenu.add(this.exitMenuItem);
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.setMnemonic(79);
        this.optionsMenu.getAccessibleContext().setAccessibleDescription("Options on parsing and translation");
        this.schemaButtonGroup = new ButtonGroup();
        this.noSchemaMenuItem = new JRadioButtonMenuItem("No Schema Validation");
        this.noSchemaMenuItem.setSelected(this.getSchemaType() == 0);
        this.noSchemaMenuItem.setMnemonic(78);
        this.schemaButtonGroup.add(this.noSchemaMenuItem);
        this.optionsMenu.add(this.noSchemaMenuItem);
        this.useDTDMenuItem = new JRadioButtonMenuItem("DTD");
        this.useDTDMenuItem.setSelected(this.getSchemaType() == 1);
        this.useDTDMenuItem.setMnemonic(68);
        this.schemaButtonGroup.add(this.useDTDMenuItem);
        this.optionsMenu.add(this.useDTDMenuItem);
        this.useXMLSchemaMenuItem = new JRadioButtonMenuItem("XML Schema");
        this.useXMLSchemaMenuItem.setSelected(this.getSchemaType() == 2);
        this.useXMLSchemaMenuItem.setMnemonic(88);
        this.schemaButtonGroup.add(this.useXMLSchemaMenuItem);
        this.optionsMenu.add(this.useXMLSchemaMenuItem);
        this.optionsMenu.addSeparator();
        this.exportButtonGroup = new ButtonGroup();
        this.exportLatexMenuItem = new JRadioButtonMenuItem("XML formatted in LaTeX");
        this.exportLatexMenuItem.setSelected(this.exportMode == 0);
        this.exportLatexMenuItem.setMnemonic(76);
        this.exportButtonGroup.add(this.exportLatexMenuItem);
        this.optionsMenu.add(this.exportLatexMenuItem);
        this.exportXMLMenuItem = new JRadioButtonMenuItem("XML indented in plain text");
        this.exportXMLMenuItem.setSelected(this.exportMode == 1);
        this.exportXMLMenuItem.setMnemonic(68);
        this.exportButtonGroup.add(this.exportXMLMenuItem);
        this.optionsMenu.add(this.exportXMLMenuItem);
        this.exportEdgeSchemaMenuItem = new JRadioButtonMenuItem("XML edge schema in LaTeX");
        this.exportEdgeSchemaMenuItem.setSelected(this.exportMode == 2);
        this.exportEdgeSchemaMenuItem.setMnemonic(88);
        this.exportButtonGroup.add(this.exportEdgeSchemaMenuItem);
        this.optionsMenu.add(this.exportEdgeSchemaMenuItem);
        this.exportElementSchemaMenuItem = new JRadioButtonMenuItem("XML element schema in LaTeX");
        this.exportElementSchemaMenuItem.setSelected(this.exportMode == 3);
        this.exportElementSchemaMenuItem.setMnemonic(88);
        this.exportButtonGroup.add(this.exportElementSchemaMenuItem);
        this.optionsMenu.add(this.exportElementSchemaMenuItem);
        this.optionsMenu.addSeparator();
        this.namespaceMenuItem = new JCheckBoxMenuItem("Use namespaces");
        this.namespaceMenuItem.setSelected(this.namespace);
        this.namespaceMenuItem.setMnemonic(78);
        this.optionsMenu.add(this.namespaceMenuItem);
        this.validationMenuItem = new JCheckBoxMenuItem("Use validation");
        this.validationMenuItem.setSelected(this.validation);
        this.validationMenuItem.setMnemonic(86);
        this.optionsMenu.add(this.validationMenuItem);
        this.parseMenuItem = new JMenuItem("Parse", 80);
        this.parseMenuItem.setAccelerator(KeyStroke.getKeyStroke(54, 8));
        this.parseMenuItem.getAccessibleContext().setAccessibleDescription("Parse the file");
        this.optionsMenu.add(this.parseMenuItem);
        this.exportMenuItem = new JMenuItem("Export", 69);
        this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(55, 8));
        this.exportMenuItem.getAccessibleContext().setAccessibleDescription("Export the file");
        this.optionsMenu.add(this.exportMenuItem);
        this.menuBar.add(this.optionsMenu);
        this.stop = new JButton("Stop");
        this.parse = new JButton("Parse XML");
        this.translate = new JButton("Translate XML");
        this.chatter = new JTextArea();
        this.er.setReportTextArea(this.chatter);
        this.viewModeBox = new JComboBox<Object>(new Object[]{"XML Source", "Translated XML", "XSLT", "Schema", "Export"});
    }

    public void listenToComponents() {
        this.text.refresh();
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.stopButton();
            }
        });
        this.translate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.chatter.setText("Translating " + XMLTool.this.XML.getFileName() + " with " + XMLTool.this.XSLT.getFileName() + "\n");
                new Execute(2);
                XMLTool.this.text.refresh();
            }
        });
        this.parse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.chatter.setText("Parsing " + XMLTool.this.XML.getFileName() + " with " + XMLTool.this.XSLT.getFileName() + "\n");
                new Execute(1);
                XMLTool.this.text.refresh();
            }
        });
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.text.open();
            }
        });
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.text.saveAs();
            }
        });
        this.parseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XMLTool.this.text.parse(XMLTool.this.schemaType, XMLTool.this.schema, XMLTool.this.namespace, XMLTool.this.validation)) {
                    XMLTool.this.chatter.setText("Parsed OK\n");
                } else {
                    XMLTool.this.chatter.setText("Parsed with Errors\n");
                }
                XMLTool.this.chatterXMLErrorHandler(XMLTool.this.text.getXMLTextFile().getXMLErrorHandler());
            }
        });
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Document document = XMLTool.this.text.getXMLTextFile().getDocument();
                    if (document == null) {
                        XMLTool.this.chatter.setText("Must parse first\n");
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    switch (XMLTool.this.exportMode) {
                        case 0: {
                            TeXXMLFormatter.formatDocument(document, printStream);
                            break;
                        }
                        case 1: {
                            IndentedXMLFormatter.formatDocument(document, printStream);
                            break;
                        }
                        case 2: {
                            EdgeSchemaFormatter.formatDocument(document, printStream);
                            break;
                        }
                        case 3: {
                            ElementSchemaFormatter.formatDocument(document, printStream);
                            break;
                        }
                        default: {
                            XMLTool.this.chatter.setText("Unknown export format");
                            return;
                        }
                    }
                    XMLTool.this.export.setText(byteArrayOutputStream.toString("UTF-8"));
                }
                catch (Exception exception) {
                    XMLTool.this.er.reportException("generating export text", exception);
                    return;
                }
                XMLTool.this.chatter.setText("Export complete");
            }
        });
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.text.save();
            }
        });
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.text.clear();
            }
        });
        this.exportLatexMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.exportMode = 0;
            }
        });
        this.exportXMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.exportMode = 1;
            }
        });
        this.exportEdgeSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.exportMode = 2;
            }
        });
        this.exportElementSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.exportMode = 3;
            }
        });
        this.noSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.setSchemaType(0);
            }
        });
        this.useDTDMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.setSchemaType(1);
            }
        });
        this.useXMLSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.setSchemaType(2);
            }
        });
        this.namespaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.namespace = XMLTool.this.namespaceMenuItem.isSelected();
            }
        });
        this.validationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLTool.this.validation = XMLTool.this.validationMenuItem.isSelected();
            }
        });
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Menu listener");
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                if (jMenuItem == XMLTool.this.exitMenuItem) {
                    System.exit(0);
                }
            }
        });
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                XMLTool.this.saveMenuItem.setEnabled(XMLTool.this.text.altered());
                XMLTool.this.saveAsMenuItem.setEnabled(XMLTool.this.text.altered());
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        this.viewModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = XMLTool.this.viewModeBox.getSelectedIndex();
                if (n != XMLTool.this.viewMode) {
                    XMLTool.this.viewMode = n;
                    switch (XMLTool.this.viewMode) {
                        case 0: {
                            XMLTool.this.text.setXMLTextFile(XMLTool.this.XML);
                            break;
                        }
                        case 1: {
                            XMLTool.this.text.setXMLTextFile(XMLTool.this.transformedXML);
                            break;
                        }
                        case 2: {
                            XMLTool.this.text.setXMLTextFile(XMLTool.this.XSLT);
                            break;
                        }
                        case 3: {
                            XMLTool.this.text.setXMLTextFile(XMLTool.this.schema);
                            break;
                        }
                        case 4: {
                            XMLTool.this.text.setXMLTextFile(XMLTool.this.export);
                        }
                    }
                }
            }
        });
    }

    public void layoutComponents() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        AWT.constrain(container, this.viewModeBox, 1, this.line, 1, 1);
        AWT.constrain(container, this.parse, 2, this.line, 1, 1);
        AWT.constrain(container, this.translate, 3, this.line, 1, 1);
        AWT.constrain(container, this.stop, 4, this.line++, 1, 1);
        AWT.constrain(container, this.text, 0, this.line++, 5, 1);
        JScrollPane jScrollPane = new JScrollPane(this.chatter);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(this.xSize, 100));
        this.chatter.setEditable(false);
        AWT.constrain(container, jScrollPane, 0, this.line++, 5, 1);
        this.protect();
    }

    private void protect() {
        if (this.noUI) {
            return;
        }
        this.stop.setEnabled(this.running);
        this.text.protect();
        this.parse.setEnabled(!this.running);
        this.translate.setEnabled(!this.running);
    }

    private void stopCommand() {
        this.running = false;
    }

    private void stopButton() {
        this.stopCommand();
        this.protect();
    }

    public void setSchemaType(int n) {
        this.schemaType = n;
    }

    public int getSchemaType() {
        return this.schemaType;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (debug > 0) {
            System.out.println("Unhandled action event " + actionEvent);
        }
    }

    private void chatterXMLErrorHandler(XMLErrorHandler xMLErrorHandler) {
        if (xMLErrorHandler != null) {
            String[] stringArray = xMLErrorHandler.getProblemListText();
            int n = 0;
            while (n < stringArray.length) {
                this.chatter.append(stringArray[n] + "\n");
                ++n;
            }
        } else {
            this.chatter.append("Failed to retrieve parsing error record");
        }
    }

    public static void main(String[] stringArray) {
        XMLTool xMLTool = new XMLTool();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) != '-') {
                    System.out.println("Error at " + stringArray[n] + "\n" + "You must use an option prefix!");
                    XMLTool.printHelp();
                    System.exit(10);
                } else if (stringArray[n].startsWith("-novalidation")) {
                    xMLTool.validation = false;
                    xMLTool.setSchemaType(0);
                } else if (stringArray[n].startsWith("-nonamespace")) {
                    xMLTool.namespace = false;
                } else if (stringArray[n].startsWith("-xmlschema")) {
                    xMLTool.setSchemaType(2);
                } else if (stringArray[n].startsWith("-dtd")) {
                    xMLTool.setSchemaType(1);
                } else if (stringArray[n].startsWith("-noUI")) {
                    xMLTool.noUI = true;
                } else if (stringArray[n].startsWith("-output")) {
                    xMLTool.transformedXML.setFileName(stringArray[++n]);
                } else if (stringArray[n].startsWith("-formatter")) {
                    xMLTool.outFormatter = stringArray[++n];
                } else if (stringArray[n].startsWith("-debug")) {
                    debug = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].startsWith("-xml")) {
                    xMLTool.XML.open(stringArray[++n]);
                } else if (stringArray[n].startsWith("-schema")) {
                    xMLTool.schema.open(stringArray[++n]);
                } else if (stringArray[n].startsWith("-xslt")) {
                    xMLTool.XSLT.open(stringArray[++n]);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (n > 0) {
                System.out.println("You must supply an argument to the " + stringArray[n - 1] + " option");
            } else {
                System.out.println("You must supply some options");
            }
            XMLTool.printHelp();
            System.exit(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XMLTool.printHelp();
            System.exit(10);
        }
        if (xMLTool.noUI) {
            try {
                if (!xMLTool.XML.parse(xMLTool.schemaType, xMLTool.schema, xMLTool.namespace, xMLTool.validation)) {
                    System.out.println("Execution failed because XML could not be parsed");
                    System.exit(1);
                }
                xMLTool.translateXML();
                System.out.println(xMLTool.transformedXML.getText());
            }
            catch (Exception exception) {
                xMLTool.er.reportException("translating " + xMLTool.XML.getFileName(), exception);
            }
        } else {
            xMLTool.new FrameUI();
        }
    }

    private void chatter(String string) {
        if (this.noUI) {
            System.out.print(string);
        } else {
            this.chatter.append(string);
        }
    }

    private void chatterClear() {
        if (!this.noUI) {
            this.chatter.setText("");
        }
    }

    private void translateXML() {
        try {
            StreamSource streamSource = new StreamSource(new StringReader(this.XSLT.getText()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(this.XML.getDocument(this.schemaType, this.schema, this.namespace, this.validation));
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            stringWriter.flush();
            this.transformedXML.setText(stringWriter.toString());
        }
        catch (Exception exception) {
            this.stopButton();
            this.chatter("Execution error:" + exception + "\n");
            exception.printStackTrace();
        }
        this.chatter("Translation completed");
    }

    static String DOMtoString(Node node) {
        if (node == null) {
            return "No document loaded";
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return "Execution error:" + exception + "\n";
        }
    }

    static void printHelp() {
        System.out.println("Usage: XMLTool [ options ]\n  -noUI           just parse XML file, and format/translate according to options\n  -debug <0-10>   set debug level\n  -output <file>  send all output to file\n  -formatter <name>  process XML using formatter\n  -novalidation   do not verify the XML using DTD or XML Schema\n  -nonamespace    do not use namespaces\n  -xmlschema      use XML Schema instead of DTD\n  -xml <file>     read XML from file\n  -xslt <file>    read XSLT from file");
    }

    public class Execute
    extends Thread {
        private int mode = 0;
        public static final int PARSE_XML = 1;
        public static final int TRANSLATE_XML = 2;

        public Execute(int n) {
            this.mode = n;
            XMLTool.this.chatterClear();
            XMLTool.this.chatter("Started command\n");
            XMLTool.this.running = true;
            XMLTool.this.protect();
            this.setPriority(10);
            this.start();
        }

        public void run() {
            switch (this.mode) {
                case 1: {
                    try {
                        Document document = XMLTool.this.XML.getDocument(XMLTool.this.schemaType, XMLTool.this.schema, XMLTool.this.namespace, XMLTool.this.validation);
                        XMLTool.this.chatterXMLErrorHandler(XMLTool.this.XML.getXMLErrorHandler());
                    }
                    catch (Exception exception) {
                        XMLTool.this.er.reportException("configuring/running the XML parser", exception);
                    }
                    break;
                }
                case 2: {
                    try {
                        XMLTool.this.XSLT.parse(XMLTool.this.schemaType, null, XMLTool.this.namespace, XMLTool.this.validation);
                        XMLTool.this.translateXML();
                    }
                    catch (Exception exception) {
                        XMLTool.this.er.reportException("translating file XML", exception);
                    }
                    break;
                }
            }
            XMLTool.this.running = false;
            XMLTool.this.protect();
        }
    }

    public class FrameUI
    extends JFrame {
        FrameUI() {
            XMLTool.this.createComponents();
            XMLTool.this.layoutComponents();
            XMLTool.this.listenToComponents();
            this.setTitle("XML Tool");
            this.setSize(new Dimension(XMLTool.this.xSize, XMLTool.this.ySize));
            this.getContentPane().add("Center", XMLTool.this);
            this.pack();
            this.show();
            XMLTool.this.start();
        }
    }
}

