/*
 * Decompiled with CFR 0.152.
 */
package db.lib;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnection {
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private boolean integrityConstraints = false;
    private boolean extraConstraints = false;
    private int debug = 0;
    private Connection con = null;
    private Statement stmt = null;
    private PreparedStatement insertStatement = null;
    private int goodInsertRows;
    private int badInsertRows;
    private String insertTable;
    private boolean connected = false;

    public boolean isConnected() {
        return this.connected;
    }

    public int getDebugLevel() {
        return this.debug;
    }

    public void setDebugLevel(int n) {
        this.debug = n;
    }

    public void close() {
        block2: {
            try {
                this.stmt.close();
                this.con.close();
                this.connected = false;
            }
            catch (Exception exception) {
                if (this.debug <= 0) break block2;
                exception.printStackTrace();
            }
        }
    }

    public ResultSet executeQuery(String string) {
        try {
            if (this.debug > 9) {
                System.out.println("Executing SQL Insert:\n" + string);
            }
            this.stmt.executeQuery(string);
            return this.stmt.getResultSet();
        }
        catch (Exception exception) {
            if (this.debug > 1) {
                if (this.debug < 10) {
                    System.out.println("Error caused by SQL Query:\n" + string);
                }
                exception.printStackTrace();
            }
            return null;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.debug > 9) {
            System.out.println("Executing SQL Update:\n" + string);
        }
        return this.stmt.executeUpdate(string);
    }

    public DBConnection(String string, String string2, String string3, String string4, int n) {
        this.driver = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        this.debug = n;
        this.makeConnection();
    }

    public DBConnection(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, 0);
    }

    public DBConnection(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("You didn't specify any arguments!");
            DBConnection.printHelp();
            System.exit(10);
        } else {
            int n = 0;
            try {
                while (n < stringArray.length) {
                    if (stringArray[n].charAt(0) != '-') {
                        System.out.println("You did not supply a valid option");
                        DBConnection.printHelp();
                        System.exit(10);
                    } else if (stringArray[n].startsWith("-integrityConstraints")) {
                        this.integrityConstraints = true;
                    } else if (stringArray[n].startsWith("-extraConstraints")) {
                        this.extraConstraints = true;
                    } else if (stringArray[n].startsWith("-debug")) {
                        this.debug = Integer.parseInt(stringArray[++n]);
                    } else if (stringArray[n].startsWith("-url")) {
                        this.url = stringArray[++n];
                    } else if (stringArray[n].startsWith("-driver")) {
                        this.driver = stringArray[++n];
                    } else if (stringArray[n].startsWith("-user")) {
                        this.user = stringArray[++n];
                    } else if (stringArray[n].startsWith("-password")) {
                        this.password = stringArray[++n];
                    }
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Must supply an integer as the debug level");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("You didn't supply an argument to the " + stringArray[n - 1] + " option");
                DBConnection.printHelp();
                System.exit(10);
            }
        }
        this.makeConnection();
    }

    private void makeConnection() {
        try {
            Class.forName(this.driver).newInstance();
            if (this.debug >= 5) {
                System.out.println("Connecting to " + this.url + " as " + this.user + " password=" + this.password);
            }
            this.con = DriverManager.getConnection(this.url, this.user, this.password);
            this.stmt = this.con.createStatement();
            this.connected = true;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("JDBC driver not in CLASSPATH");
            classNotFoundException.printStackTrace();
        }
    }

    public void createTable(String string, String string2) throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE " + string);
            System.out.println("Dropped old " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE " + string + " (" + string2 + ")");
    }

    public void allowUserToReadTable(String string, String string2) {
        try {
            this.stmt.executeUpdate("GRANT SELECT ON " + string + " TO " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addExtraConstraint(String string, String string2) {
        if (this.extraConstraints) {
            this.addConstraint(string, string2);
        }
    }

    public void addConstraint(String string, String string2) {
        if (!this.integrityConstraints) {
            return;
        }
        try {
            this.stmt.executeUpdate("ALTER TABLE " + string + " " + "ADD CONSTRAINT " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printHelp() {
        System.out.println("Options:\n  -debug <0-10>           set debug level\n  -url <dbURL>            URL where DB located\n  -driver <jdbcDriverClass>\n  -user <user>\n  -password <password>\n  -integrityConstraints   add integrity Constraints  -extraConstraints       add more integrity Constraints");
    }

    public PreparedStatement prepareInsert(String string, String string2) {
        block3: {
            try {
                this.insertStatement = this.con.prepareStatement("INSERT INTO " + string + " VALUES " + string2);
            }
            catch (SQLException sQLException) {
                if (this.debug > 5) {
                    sQLException.printStackTrace();
                }
                if (this.debug <= 1) break block3;
                System.out.println(sQLException);
            }
        }
        this.goodInsertRows = 0;
        this.badInsertRows = 0;
        this.insertTable = string;
        return this.insertStatement;
    }

    public void executeInsert() throws Exception {
        try {
            this.insertStatement.execute();
            ++this.goodInsertRows;
            if (this.debug > 9) {
                System.out.println("Inserted row " + this.goodInsertRows);
            }
        }
        catch (Exception exception) {
            ++this.badInsertRows;
            if (this.debug > 1) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void finishInsert() {
        block2: {
            try {
                this.stmt.executeUpdate("DUMP TRANSACTION usgs WITH TRUNCATE_ONLY");
                this.stmt.executeUpdate("CHECKPOINT");
            }
            catch (SQLException sQLException) {
                if (this.debug <= 7) break block2;
                sQLException.printStackTrace();
            }
        }
        System.out.println("Inserted " + this.goodInsertRows + " records into " + this.insertTable + ", and rejected " + this.badInsertRows + " records");
        this.insertStatement = null;
    }

    public void setInsertString(int n, String string) throws Exception {
        String string2 = string.trim();
        try {
            if (string2.length() == 0) {
                this.insertStatement.setNull(n, 12);
            } else {
                this.insertStatement.setString(n, string2);
            }
        }
        catch (Exception exception) {
            ++this.badInsertRows;
            throw exception;
        }
    }

    public void setInsertInt(int n, String string) throws Exception {
        String string2 = string.trim();
        try {
            if (string2.length() == 0) {
                this.insertStatement.setNull(n, 4);
            } else {
                this.insertStatement.setInt(n, Integer.parseInt(string2));
            }
        }
        catch (Exception exception) {
            ++this.badInsertRows;
            if (this.debug > 2) {
                System.out.println("Bad integer text: " + string2);
            }
            throw exception;
        }
    }

    public void setInsertDouble(int n, String string) throws Exception {
        String string2 = string.trim();
        try {
            if (string2.length() == 0) {
                this.insertStatement.setNull(n, 8);
            } else {
                this.insertStatement.setDouble(n, Double.parseDouble(string2));
            }
        }
        catch (Exception exception) {
            ++this.badInsertRows;
            throw exception;
        }
    }

    public void setInsertDouble(int n, double d) throws Exception {
        try {
            this.insertStatement.setDouble(n, d);
        }
        catch (Exception exception) {
            ++this.badInsertRows;
            throw exception;
        }
    }

    public ResultSet getTables(String string) throws SQLException {
        try {
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            return databaseMetaData.getTables(null, null, string, new String[]{"TABLE"});
        }
        catch (SQLException sQLException) {
            if (this.debug > 1) {
                sQLException.printStackTrace();
            }
            throw sQLException;
        }
    }
}

