/*
 * Decompiled with CFR 0.152.
 */
package db.lib;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLErrorHandler
extends HandlerBase {
    private int errorCount = 0;
    private int warningCount = 0;
    private String uri = null;
    private PrintStream output = System.out;

    XMLErrorHandler(PrintStream printStream) {
        this.output = printStream;
    }

    XMLErrorHandler() {
    }

    private String sax(String string) {
        return "XML " + string + ": ";
    }

    private void reportProblem(SAXParseException sAXParseException, String string) {
        String string2 = sAXParseException.getSystemId();
        if (!string2.equals(this.uri)) {
            this.output.println("File: " + string2);
            this.uri = string2;
        }
        this.output.println("XML " + string + " on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }

    public void exitIfErrors() {
        if (this.errorCount > 0 || this.warningCount > 0) {
            this.output.println("XML file contained " + this.errorCount + " error" + (this.errorCount == 1 ? "" : "s") + " and " + this.warningCount + " warnings" + (this.warningCount == 1 ? "" : "s"));
        }
        if (this.errorCount > 0) {
            System.exit(1);
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Error");
        ++this.errorCount;
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Fatal Error");
    }

    public void warning(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Warning");
        ++this.warningCount;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.output.println(this.sax("Characters") + "ch=" + new String(cArray, n, n2) + " start=" + n + ", length=" + n2);
    }

    public void endDocument() {
        this.output.println(this.sax("End Document"));
    }

    public void endElement(String string) {
        this.output.println(this.sax("End Element") + string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.output.println(this.sax("Ignorable White Space") + "start=" + n + ", length=" + n2);
    }

    public void notationDecl(String string, String string2, String string3) {
        this.output.println(this.sax("Notation Declaration") + "name=" + string + ", publicId=" + string2 + ", systemId=" + string3);
    }

    public void processingInstruction(String string, String string2) {
        this.output.println(this.sax("Processing Intrstruction") + "target=" + string + ", data=" + string2);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        this.output.println(this.sax("Processing Intrstruction") + "publicId=" + string + ", systemId=" + string2);
        return super.resolveEntity(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        this.output.println(this.sax("Locator") + locator);
    }

    public void startDocument() {
        this.output.println(this.sax("Start Document"));
    }

    public void startElement(String string, AttributeList attributeList) {
        this.output.println(this.sax("Start Element") + string);
        int n = 0;
        while (n < attributeList.getLength()) {
            this.output.println("   Attribute[" + n + "]: " + "name=" + attributeList.getName(n) + ", type=" + attributeList.getType(n) + ", value=" + attributeList.getValue(n));
            ++n;
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }
}

