/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class EdgeSchemaFormatter {
    private PrintStream output = System.out;
    private Document doc;
    private static int id = 0;

    public static void formatDocument(Document document, PrintStream printStream) {
        EdgeSchemaFormatter edgeSchemaFormatter = new EdgeSchemaFormatter();
        edgeSchemaFormatter.doc = document;
        edgeSchemaFormatter.output = printStream;
        edgeSchemaFormatter.formatHeadAndFoot(edgeSchemaFormatter.doc.getDocumentElement(), id++, 0);
    }

    public void format(Document document) {
        this.formatHeadAndFoot(document.getDocumentElement(), id++, 0);
    }

    public void format() {
        this.formatHeadAndFoot(this.doc, id++, 0);
    }

    public void format(Node node) {
        this.formatHeadAndFoot(node, id++, 0);
    }

    private void printNode(int n, int n2, int n3, String string, String string2, String string3) {
        if (id % 2 == 1) {
            this.output.println("\\rowcolor{evenrow}");
        } else {
            this.output.println("\\rowcolor{oddrow}");
        }
        this.output.println(n + " & " + n2 + " & " + n3 + " & " + this.safeLaTeXString(string) + " & " + this.safeLaTeXString(string2) + " & " + this.safeLaTeXString(string3) + " \\\\");
    }

    public String safeLaTeXString(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            switch (stringBuffer.charAt(n)) {
                case '#': 
                case '&': 
                case '\\': 
                case '_': {
                    stringBuffer.insert(n++, '\\');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private int formatHeadAndFoot(Node node, int n, int n2) {
        this.output.println("\\begin{tabular}{lllrrr}");
        this.output.println("\\rowcolor{header}");
        this.output.println("id & pid & cord & type & name & value \\\\");
        int n3 = this.format(node, n, n2);
        this.output.println("\\end{tabular}");
        return n3;
    }

    private int format(Node node, int n, int n2) {
        int n3 = id++;
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = node.getFirstChild();
                int n4 = 1;
                this.printNode(n3, n, n2++, "element", node.getNodeName(), "null");
                int n5 = 0;
                while (n5 < namedNodeMap.getLength()) {
                    n4 = this.format(namedNodeMap.item(n5), n3, n4);
                    ++n5;
                }
                while (node2 != null) {
                    n4 = this.format(node2, n3, n4);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 6: {
                this.printNode(n3, n, n2++, "entity", node.getNodeName(), "null");
                break;
            }
            case 2: {
                this.printNode(n3, n, -1, "attribute", node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                this.printNode(n3, n, n2++, "comment", "null", node.getNodeValue());
                break;
            }
            case 4: {
                this.printNode(n3, n, n2++, "cdata", "null", node.getNodeValue());
                break;
            }
            case 3: {
                String string = node.getNodeValue().trim();
                if (string.length() > 0) {
                    this.printNode(n3, n, n2++, "cdata", "null", string);
                    break;
                }
                --id;
                break;
            }
            case 7: {
                this.printNode(n3, n, n2++, "process", ((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            default: {
                this.printNode(n3, n, -1, "unknown", "null", "null");
            }
        }
        return n2;
    }
}

