/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.LaTeX;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ElementSchemaFormatter {
    private PrintStream output = System.out;
    private Document doc;
    private int id = 0;
    private TreeMap nameToTable = new TreeMap();
    private TreeMap idToTable = new TreeMap();

    public static void formatDocument(Document document, PrintStream printStream) {
        ElementSchemaFormatter elementSchemaFormatter = new ElementSchemaFormatter();
        elementSchemaFormatter.doc = document;
        elementSchemaFormatter.output = printStream;
        elementSchemaFormatter.formatToLaTeX(elementSchemaFormatter.doc.getDocumentElement(), elementSchemaFormatter.id++, 0);
    }

    private int formatToLaTeX(Node node, int n, int n2) {
        int n3 = this.format(node, n, n2);
        Table[] tableArray = this.nameToTable.values().toArray(new Table[0]);
        int n4 = 0;
        while (n4 < tableArray.length) {
            if (n4 > 0) {
                this.output.println();
            }
            tableArray[n4].writeLaTeX(this.output);
            ++n4;
        }
        return n3;
    }

    private void addTableRow(String string, int n) {
        Table table = (Table)this.nameToTable.get(string);
        if (table == null) {
            table = new Table(string);
            this.nameToTable.put(string, table);
        }
        table.assertField("id", n, "" + n);
        this.idToTable.put(new Integer(n), table);
    }

    private void assertTableField(int n, String string, String string2) {
        Table table = (Table)this.idToTable.get(new Integer(n));
        table.assertField(string, n, string2);
    }

    private void assertTableField(int n, String string, int n2) {
        this.assertTableField(n, string, "" + n2);
    }

    private int format(Node node, int n, int n2) {
        int n3 = this.id++;
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = node.getFirstChild();
                int n4 = 1;
                this.addTableRow(node.getNodeName(), n3);
                this.assertTableField(n3, "pid", n);
                this.assertTableField(n3, "ord", n2++);
                int n5 = 0;
                while (n5 < namedNodeMap.getLength()) {
                    n4 = this.format(namedNodeMap.item(n5), n3, n4);
                    ++n5;
                }
                while (node2 != null) {
                    n4 = this.format(node2, n3, n4);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 6: {
                this.addTableRow("entity", n3);
                this.assertTableField(n3, "pid", n);
                this.assertTableField(n3, "ord", n2++);
                break;
            }
            case 2: {
                this.assertTableField(n, node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                this.addTableRow("comment", n3);
                this.assertTableField(n3, "pid", n);
                this.assertTableField(n3, "ord", n2++);
                this.assertTableField(n3, "value", node.getNodeValue());
                break;
            }
            case 4: {
                this.addTableRow("cdata", n3);
                this.assertTableField(n3, "pid", n);
                this.assertTableField(n3, "ord", n2++);
                this.assertTableField(n3, "value", node.getNodeValue());
                break;
            }
            case 3: {
                String string = node.getNodeValue().trim();
                if (string.length() > 0) {
                    this.addTableRow("cdata", n3);
                    this.assertTableField(n3, "pid", n);
                    this.assertTableField(n3, "ord", n2++);
                    this.assertTableField(n3, "value", string);
                    break;
                }
                --this.id;
                break;
            }
            case 7: {
                this.addTableRow("process", n3);
                this.assertTableField(n3, "pid", n);
                this.assertTableField(n3, "ord", n2++);
                this.assertTableField(n3, "name", ((ProcessingInstruction)node).getTarget());
                this.assertTableField(n3, "value", ((ProcessingInstruction)node).getData());
                break;
            }
            default: {
                System.out.println("ElementSchemaFormatter can not handle node " + n3 + " child of " + n);
            }
        }
        return n2;
    }

    class Table {
        String name;
        ArrayList fields = new ArrayList();
        TreeMap pidToRow = new TreeMap();

        public Table(String string) {
            this.name = string;
            this.assertField("id");
            this.assertField("pid");
            this.assertField("ord");
        }

        public void assertField(String string) {
            if (!this.fields.contains(string)) {
                this.fields.add(string);
            }
        }

        public void assertField(String string, int n, String string2) {
            Integer n2 = new Integer(n);
            TreeMap<String, String> treeMap = (TreeMap<String, String>)this.pidToRow.get(n2);
            this.assertField(string);
            if (treeMap == null) {
                treeMap = new TreeMap<String, String>();
                this.pidToRow.put(n2, treeMap);
            }
            treeMap.put(string, string2);
        }

        public String[][] getRows() {
            TreeMap[] treeMapArray = this.pidToRow.values().toArray(new TreeMap[0]);
            int n = this.fields.size();
            String[][] stringArray = new String[treeMapArray.length][n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                TreeMap treeMap = treeMapArray[n2];
                int n3 = 0;
                while (n3 < stringArray[n2].length) {
                    String string;
                    String string2 = (String)this.fields.get(n3);
                    if (string2 == null) {
                        System.out.println("Error: no field " + n3 + " in " + this.name);
                        string2 = "error";
                    }
                    stringArray[n2][n3] = (string = (String)treeMap.get(string2)) == null ? "null" : string;
                    ++n3;
                }
                ++n2;
            }
            return stringArray;
        }

        public String[] getSchema() {
            return this.fields.toArray(new String[0]);
        }

        public void writeLaTeX(PrintStream printStream) {
            printStream.print("\\begin{tabular}{");
            int n = 0;
            while (n < this.fields.size()) {
                printStream.print("l");
                ++n;
            }
            printStream.println("}");
            printStream.println("\\multicolumn{" + this.fields.size() + "}" + "{>{\\columncolor{header}}c}{" + LaTeX.safeLaTeXString(this.name) + "}\\\\");
            printStream.println("\\rowcolor{header}");
            int n2 = 0;
            while (n2 < this.fields.size()) {
                if (n2 > 0) {
                    printStream.print("&");
                }
                printStream.print(LaTeX.safeLaTeXString((String)this.fields.get(n2)));
                ++n2;
            }
            printStream.println("\\\\");
            String[][] stringArray = this.getRows();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (n3 % 2 == 1) {
                    printStream.println("\\rowcolor{evenrow}");
                } else {
                    printStream.println("\\rowcolor{oddrow}");
                }
                int n4 = 0;
                while (n4 < stringArray[n3].length) {
                    if (n4 > 0) {
                        printStream.print(" & ");
                    }
                    printStream.print(LaTeX.safeLaTeXString(stringArray[n3][n4]));
                    ++n4;
                }
                printStream.println(n3 + 1 < stringArray.length ? "\\\\" : "");
                ++n3;
            }
            printStream.println("\\end{tabular}");
        }
    }
}

