/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class IndentedXMLFormatter {
    private PrintStream output = System.out;
    private Document doc;

    public static void formatDocument(Document document, PrintStream printStream) {
        IndentedXMLFormatter indentedXMLFormatter = new IndentedXMLFormatter();
        indentedXMLFormatter.doc = document;
        indentedXMLFormatter.output = printStream;
        indentedXMLFormatter.format();
    }

    public void format(Document document) {
        this.format(document.getDocumentElement(), 0);
    }

    public void format() {
        this.format(this.doc, 0);
    }

    public void format(Node node) {
        this.format(node, 0);
    }

    private void format(Node node, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.output.print(" ");
            ++n2;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.output.println("ELEMENT " + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = 0;
                while (n3 < namedNodeMap.getLength()) {
                    this.format(namedNodeMap.item(n3), n + 2);
                    ++n3;
                }
                break;
            }
            case 6: {
                this.output.println("ENTITY " + node.getNodeName());
                break;
            }
            case 2: {
                this.output.println("ATTRIBUTE " + node.getNodeName() + "=" + node.getNodeValue());
                break;
            }
            case 8: {
                this.output.println("COMMENT " + node.getNodeValue());
                break;
            }
            case 4: {
                this.output.println("CDATA " + node.getNodeValue());
                break;
            }
            case 3: {
                this.output.println("TEXT " + node.getNodeValue());
                break;
            }
            case 7: {
                this.output.println("PROCESSING INSTRUCTION for " + ((ProcessingInstruction)node).getTarget() + ": " + ((ProcessingInstruction)node).getData());
                break;
            }
            default: {
                this.output.println("UNKNOWN");
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.format(node2, n + 2);
            node2 = node2.getNextSibling();
        }
    }
}

