/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class TeXXMLFormatter {
    private PrintStream output = System.out;
    private Document doc;

    public static void formatDocument(Document document, PrintStream printStream) {
        TeXXMLFormatter teXXMLFormatter = new TeXXMLFormatter();
        teXXMLFormatter.doc = document;
        teXXMLFormatter.output = printStream;
        teXXMLFormatter.format(teXXMLFormatter.doc.getDocumentElement(), 0, true);
    }

    public void format(Document document) {
        this.format(document.getDocumentElement(), 0, true);
    }

    public void format() {
        this.format(this.doc, 0, true);
    }

    public void format(Node node) {
        this.format(node, 0, true);
    }

    private void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.output.print(" ");
            ++n2;
        }
    }

    private boolean format(Node node, int n, boolean bl) {
        switch (node.getNodeType()) {
            case 1: {
                boolean bl2;
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = node.getFirstChild();
                boolean bl3 = bl2 = node2 == null;
                if (!bl) {
                    this.indent(n);
                    this.output.println("\\\\");
                }
                this.indent(n);
                if (bl2) {
                    this.output.print("\\xmlopenclosetag");
                } else {
                    this.output.print("\\begin{xml}");
                }
                this.output.print("{" + node.getNodeName() + "}{");
                int n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    this.format(namedNodeMap.item(n2), n + 2, true);
                    ++n2;
                }
                this.output.println("}");
                boolean bl4 = true;
                while (node2 != null) {
                    if (this.format(node2, n + 2, bl4)) {
                        bl4 = false;
                    }
                    node2 = node2.getNextSibling();
                }
                if (bl2) break;
                this.indent(n);
                this.output.println("\\end{xml}");
                break;
            }
            case 6: {
                this.output.println("\\xmlentity{" + node.getNodeName() + "}");
                break;
            }
            case 2: {
                this.output.print("\\xmlav{" + node.getNodeName() + "}{" + node.getNodeValue() + "}");
                break;
            }
            case 8: {
                this.output.println("\\xmlcomment{" + node.getNodeValue() + "}");
                break;
            }
            case 4: {
                this.output.println("\\xmlcdata{" + node.getNodeValue() + "}");
                break;
            }
            case 3: {
                String string = node.getNodeValue().trim();
                this.output.print(string);
                return string.length() > 0;
            }
            case 7: {
                this.output.println("\\xmlprocess{" + ((ProcessingInstruction)node).getTarget() + "}{" + ((ProcessingInstruction)node).getData() + "}");
                break;
            }
            default: {
                this.output.println("UNKNOWN");
            }
        }
        return true;
    }
}

