/*
 * Decompiled with CFR 0.152.
 */
package db.uscensus1990;

import db.lib.CSVTokeniser;
import db.lib.DBConnection;
import db.uscensus1990.DBNullValueException;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.sql.PreparedStatement;

public class BuildUSCensus1990 {
    private static RandomAccessFile fd = null;
    private static DBConnection con = null;
    private static boolean removeSingleQuote = true;
    private static long timer = System.currentTimeMillis();

    static double addDPtoFIPSLatLong(String string) {
        int n = string.length();
        return Double.parseDouble(string.substring(0, n - 6) + "." + string.substring(n - 6, n));
    }

    static void loadFile(String string) {
        try {
            if (fd != null) {
                fd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Reading data file " + string);
        try {
            fd = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + string + " not found");
        }
    }

    private static void readPlaceFormat(String string) throws Exception {
        String string2;
        con.createTable(string, "stateCode INT NOT NULL,countyCode INT NOT NULL,name CHAR(70) NOT NULL,population INT NOT NULL,housingUnits INT NOT NULL,landArea INT NOT NULL,waterArea INT NOT NULL,latitude DECIMAL(12,6) NOT NULL,longitude DECIMAL(12,6) NOT NULL");
        con.addConstraint(string, string + "_PK PRIMARY KEY (stateCode, countyCode)");
        con.addConstraint(string, string + "_stateCode_FK FOREIGN KEY (stateCode) " + "REFERENCES state(code)");
        PreparedStatement preparedStatement = con.prepareInsert(string, "(?,?,?,?,?,?,?,?,?)");
        while ((string2 = fd.readLine()) != null) {
            try {
                con.setInsertInt(1, string2.substring(0, 2));
                con.setInsertInt(2, string2.substring(3, 8));
                con.setInsertString(3, string2.substring(9, 75));
                con.setInsertInt(4, string2.substring(79, 88));
                con.setInsertInt(5, string2.substring(89, 98));
                con.setInsertInt(6, string2.substring(99, 109));
                con.setInsertInt(7, string2.substring(110, 120));
                con.setInsertDouble(8, BuildUSCensus1990.addDPtoFIPSLatLong(string2.substring(121, 130)));
                con.setInsertDouble(9, BuildUSCensus1990.addDPtoFIPSLatLong(string2.substring(131, 141)));
                con.executeInsert();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void resetTimer() {
        timer = System.currentTimeMillis();
    }

    private static void printTimer(String string) {
        System.out.println(string + (double)(System.currentTimeMillis() - timer) / 1000.0 + "s");
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string = "";
            int n = 0;
            con = new DBConnection(stringArray);
            con.executeUpdate("DROP TABLE mcd");
            con.executeUpdate("DROP TABLE county,place,zip");
            con.executeUpdate("DROP TABLE state");
            System.out.println("Dropped old uscensus1990 database");
            BuildUSCensus1990.loadFile("states.txt");
            String string2 = "state";
            BuildUSCensus1990.resetTimer();
            con.createTable(string2, "code INT NOT NULL,abbr CHAR(2) NOT NULL,name CHAR(30) NOT NULL");
            con.addConstraint(string2, "state_PK PRIMARY KEY (code)");
            con.executeUpdate("CREATE UNIQUE INDEX state_name ON state(name)");
            con.executeUpdate("CREATE UNIQUE INDEX state_abbr ON state(abbr)");
            con.prepareInsert(string2, "(?,?,?)");
            while ((string = fd.readLine()) != null) {
                con.setInsertInt(1, string.substring(0, 2));
                con.setInsertString(2, string.substring(11, 13));
                con.setInsertString(3, string.substring(21));
                con.executeInsert();
            }
            con.finishInsert();
            BuildUSCensus1990.printTimer("Import to state took ");
            BuildUSCensus1990.loadFile("places.txt");
            BuildUSCensus1990.resetTimer();
            BuildUSCensus1990.readPlaceFormat("place");
            con.finishInsert();
            BuildUSCensus1990.printTimer("Import to places took ");
            BuildUSCensus1990.loadFile("counties.txt");
            BuildUSCensus1990.resetTimer();
            BuildUSCensus1990.readPlaceFormat("county");
            con.finishInsert();
            BuildUSCensus1990.printTimer("Import to county took ");
            BuildUSCensus1990.loadFile("mcds.txt");
            BuildUSCensus1990.resetTimer();
            string2 = "mcd";
            con.createTable(string2, "stateCode INT NOT NULL,countyCode INT NOT NULL,countySubdivisionCode INT NOT NULL,name CHAR(60) NOT NULL,type CHAR(20) NULL,population INT NOT NULL,housingUnits INT NOT NULL,landArea INT NOT NULL,waterArea INT NOT NULL,latitude DECIMAL(12,6) NOT NULL,longitude DECIMAL(12,6) NOT NULL");
            con.addConstraint(string2, "mcd_PK PRIMARY KEY (stateCode, countySubdivisionCode, countyCode)");
            con.addConstraint(string2, "mcd_stateCode_FK FOREIGN KEY (stateCode) REFERENCES state(code)");
            con.addExtraConstraint(string2, "mcd_stateCode_countyCode_FK FOREIGN KEY (stateCode,CountyCode)REFERENCES county(stateCode,countyCode)");
            con.prepareInsert(string2, "(?,?,?,?,?,?,?,?,?,?,?)");
            while ((string = fd.readLine()) != null) {
                try {
                    object = string.substring(76, 78);
                    String string3 = string.substring(9, 75).trim();
                    String string4 = "NULL";
                    int n2 = string3.lastIndexOf(32);
                    if (string3.length() > 8 && string3.substring(0, 9).equals("District ")) {
                        string4 = "'district'";
                    } else if (string3.length() > 8 && string3.substring(0, 9).equals("Precinct ")) {
                        string4 = "'precinct'";
                    } else if (string3.length() > 8 && string3.substring(0, 9).equals("Township ")) {
                        string4 = "'township'";
                    } else if (string3.length() > 14 && string3.substring(string3.length() - 14).equals("census subarea")) {
                        string4 = "'census subarea'";
                    } else if (n2 > 0 && Character.isLowerCase(string3.charAt(n2 + 1))) {
                        string4 = "'" + string3.substring(n2 + 1) + "'";
                        string3 = string3.substring(0, n2);
                    }
                    string3 = "'" + string3 + "'";
                    con.setInsertInt(1, string.substring(0, 2));
                    con.setInsertInt(2, string.substring(142, 145));
                    con.setInsertInt(3, string.substring(3, 8));
                    con.setInsertString(4, string3);
                    con.setInsertString(5, string4);
                    con.setInsertInt(6, string.substring(79, 88));
                    con.setInsertInt(7, string.substring(89, 98));
                    con.setInsertInt(8, string.substring(99, 109));
                    con.setInsertInt(9, string.substring(110, 120));
                    con.setInsertDouble(10, BuildUSCensus1990.addDPtoFIPSLatLong(string.substring(121, 130)));
                    con.setInsertDouble(11, BuildUSCensus1990.addDPtoFIPSLatLong(string.substring(131, 141)));
                    con.executeInsert();
                }
                catch (DBNullValueException dBNullValueException) {
                    System.out.println("Ignoring null value in:\n" + string);
                }
                catch (Exception exception) {
                    System.out.println("Error reading row " + n + ":\n" + string);
                    exception.printStackTrace();
                }
            }
            con.finishInsert();
            BuildUSCensus1990.printTimer("Import to mcd took ");
            BuildUSCensus1990.loadFile("zips.txt");
            BuildUSCensus1990.resetTimer();
            string2 = "zip";
            con.createTable(string2, "stateCode INT NOT NULL,zipCode INT NOT NULL,zipName CHAR(20) NOT NULL,longitude DECIMAL(18,8) NOT NULL,latitude DECIMAL(18,8) NOT NULL,population INT NOT NULL,allocationFactor DECIMAL(10,8) NOT NULL");
            con.addConstraint(string2, "zip_PK PRIMARY KEY (zipCode)");
            con.addConstraint(string2, "zip_stateCode_FK FOREIGN KEY (stateCode) REFERENCES state(code)");
            con.prepareInsert(string2, "(?,?,?,?,?,?,?)");
            while ((string = fd.readLine()) != null) {
                try {
                    object = new CSVTokeniser(string);
                    con.setInsertInt(1, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(2, ((CSVTokeniser)object).getNextToken());
                    ((CSVTokeniser)object).getNextToken();
                    con.setInsertString(3, ((CSVTokeniser)object).getNextToken());
                    con.setInsertDouble(4, ((CSVTokeniser)object).getNextToken());
                    con.setInsertDouble(5, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(6, ((CSVTokeniser)object).getNextToken());
                    con.setInsertDouble(7, ((CSVTokeniser)object).getNextToken());
                    con.executeInsert();
                }
                catch (DBNullValueException dBNullValueException) {
                    System.out.println("Ignoring null value in:\n" + string);
                }
                catch (Exception exception) {
                    System.out.println("Error reading row " + n + ":\n" + string);
                    exception.printStackTrace();
                }
            }
            con.finishInsert();
            BuildUSCensus1990.printTimer("Import to zip took ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

