/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Blitzer {
    public static final int DEFAULT_THREAD_COUNT = 2;
    private final ExecutorService executorService;
    private final int actionCount;

    public Blitzer(int actionCount) {
        this(actionCount, 2);
    }

    public Blitzer(int actionCount, int threadCount) {
        this(actionCount, threadCount, Executors.defaultThreadFactory());
    }

    public Blitzer(int actionCount, int threadCount, ThreadFactory threadFactory) {
        this.actionCount = actionCount;
        this.executorService = Executors.newFixedThreadPool(threadCount, threadFactory);
    }

    public Blitzer(int actionCount, ExecutorService executorService) {
        this.actionCount = actionCount;
        this.executorService = executorService;
    }

    public int totalActionCount() {
        return this.actionCount;
    }

    public void blitz(Runnable action) throws InterruptedException {
        this.spawnThreads(action).await();
    }

    public void blitz(long timeoutMs, Runnable action) throws InterruptedException, TimeoutException {
        if (!this.spawnThreads(action).await(timeoutMs, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("timed out waiting for blitzed actions to complete successfully");
        }
    }

    private CountDownLatch spawnThreads(final Runnable action) {
        final CountDownLatch finished = new CountDownLatch(this.actionCount);
        for (int i = 0; i < this.actionCount; ++i) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.run();
                    }
                    finally {
                        finished.countDown();
                    }
                }
            });
        }
        return finished;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

