/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchingClassLoader
extends ClassLoader {
    private final ClassLoader nextToSearch;

    public SearchingClassLoader(ClassLoader parent, ClassLoader nextToSearch) {
        super(parent);
        this.nextToSearch = nextToSearch;
    }

    public static ClassLoader combine(ClassLoader ... parentLoaders) {
        return SearchingClassLoader.combine(Arrays.asList(parentLoaders));
    }

    public static ClassLoader combine(List<ClassLoader> parentLoaders) {
        ClassLoader loader = parentLoaders.get(parentLoaders.size() - 1);
        for (int i = parentLoaders.size() - 2; i >= 0; --i) {
            loader = new SearchingClassLoader(parentLoaders.get(i), loader);
        }
        return loader;
    }

    public static ClassLoader combineLoadersOf(Class<?> ... classes) {
        return SearchingClassLoader.combineLoadersOf(classes[0], classes);
    }

    public static ClassLoader combineLoadersOf(Class<?> first, Class<?> ... others) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        SearchingClassLoader.addIfNewElement(loaders, first.getClassLoader());
        for (Class<?> c : others) {
            SearchingClassLoader.addIfNewElement(loaders, c.getClassLoader());
        }
        SearchingClassLoader.addIfNewElement(loaders, SearchingClassLoader.class.getClassLoader());
        SearchingClassLoader.addIfNewElement(loaders, Thread.currentThread().getContextClassLoader());
        SearchingClassLoader.addIfNewElement(loaders, ClassLoader.getSystemClassLoader());
        return SearchingClassLoader.combine(loaders);
    }

    private static void addIfNewElement(List<ClassLoader> loaders, ClassLoader c) {
        if (c != null && !loaders.contains(c)) {
            loaders.add(c);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.nextToSearch != null) {
            return this.nextToSearch.loadClass(name);
        }
        return super.findClass(name);
    }
}

