/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.jmock.Sequence;
import org.jmock.api.Action;
import org.jmock.api.Expectation;
import org.jmock.api.Invocation;
import org.jmock.internal.CaptureControl;
import org.jmock.internal.Cardinality;
import org.jmock.internal.ExpectationCapture;
import org.jmock.internal.InvocationExpectation;
import org.jmock.internal.OrderingConstraint;
import org.jmock.internal.SideEffect;
import org.jmock.internal.matcher.AllParametersMatcher;
import org.jmock.internal.matcher.MethodNameMatcher;
import org.jmock.internal.matcher.MockObjectMatcher;
import org.jmock.syntax.MethodClause;
import org.jmock.syntax.ParametersClause;
import org.jmock.syntax.ReceiverClause;

public class InvocationExpectationBuilder
implements ExpectationCapture,
ReceiverClause,
MethodClause,
ParametersClause {
    private final InvocationExpectation expectation = new InvocationExpectation();
    private boolean isFullySpecified = false;
    private boolean needsDefaultAction = true;
    private List<Matcher<?>> capturedParameterMatchers = new ArrayList();

    public Expectation toExpectation(Action defaultAction) {
        if (this.needsDefaultAction) {
            this.expectation.setDefaultAction(defaultAction);
        }
        return this.expectation;
    }

    public void setCardinality(Cardinality cardinality) {
        this.expectation.setCardinality(cardinality);
    }

    public void addParameterMatcher(Matcher<?> matcher) {
        this.capturedParameterMatchers.add(matcher);
    }

    public void addOrderingConstraint(OrderingConstraint constraint) {
        this.expectation.addOrderingConstraint(constraint);
    }

    public void addInSequenceOrderingConstraint(Sequence sequence) {
        sequence.constrainAsNextInSequence(this.expectation);
    }

    public void setAction(Action action) {
        this.expectation.setAction(action);
        this.needsDefaultAction = false;
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.expectation.addSideEffect(sideEffect);
    }

    private <T> T captureExpectedObject(T mockObject) {
        if (!(mockObject instanceof CaptureControl)) {
            throw new IllegalArgumentException("can only set expectations on mock objects");
        }
        this.expectation.setObjectMatcher((Matcher<?>)new MockObjectMatcher(mockObject));
        this.isFullySpecified = true;
        Object capturingImposter = ((CaptureControl)mockObject).captureExpectationTo(this);
        return this.asMockedType(mockObject, capturingImposter);
    }

    private <T> T asMockedType(T mockObject, Object capturingImposter) {
        return (T)capturingImposter;
    }

    @Override
    public void createExpectationFrom(Invocation invocation) {
        this.expectation.setMethod(invocation.getInvokedMethod());
        if (this.capturedParameterMatchers.isEmpty()) {
            this.expectation.setParametersMatcher(new AllParametersMatcher(invocation.getParametersAsArray()));
        } else {
            this.checkParameterMatcherCount(invocation);
            this.expectation.setParametersMatcher(new AllParametersMatcher(this.capturedParameterMatchers));
        }
    }

    private void checkParameterMatcherCount(Invocation invocation) {
        if (this.capturedParameterMatchers.size() != invocation.getParameterCount()) {
            throw new IllegalArgumentException("not all parameters were given explicit matchers: either all parameters must be specified by matchers or all must be specified by values, you cannot mix matchers and values");
        }
    }

    public void checkWasFullySpecified() {
        if (!this.isFullySpecified) {
            throw new IllegalStateException("expectation was not fully specified");
        }
    }

    @Override
    public <T> T of(T mockObject) {
        return this.captureExpectedObject(mockObject);
    }

    @Override
    public MethodClause of(Matcher<?> objectMatcher) {
        this.expectation.setObjectMatcher(objectMatcher);
        this.isFullySpecified = true;
        return this;
    }

    @Override
    public ParametersClause method(Matcher<Method> methodMatcher) {
        this.expectation.setMethodMatcher(methodMatcher);
        return this;
    }

    @Override
    public ParametersClause method(String nameRegex) {
        return this.method((Matcher<Method>)new MethodNameMatcher(nameRegex));
    }

    @Override
    public void with(Matcher<?> ... parameterMatchers) {
        this.expectation.setParametersMatcher(new AllParametersMatcher(Arrays.asList(parameterMatchers)));
    }

    @Override
    public void withNoArguments() {
        this.with(new Matcher[0]);
    }
}

