/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;
import org.jmock.api.Action;
import org.jmock.api.Expectation;
import org.jmock.api.Invocation;
import org.jmock.internal.Cardinality;
import org.jmock.internal.Formatting;
import org.jmock.internal.OrderingConstraint;
import org.jmock.internal.ParametersMatcher;
import org.jmock.internal.SideEffect;
import org.jmock.internal.matcher.MethodMatcher;
import org.jmock.lib.action.VoidAction;

public class InvocationExpectation
implements Expectation {
    private static ParametersMatcher ANY_PARAMETERS = new AnyParametersMatcher();
    private Cardinality cardinality = Cardinality.ALLOWING;
    private Matcher<?> objectMatcher = IsAnything.anything();
    private Matcher<? super Method> methodMatcher = IsAnything.anything((String)"<any method>");
    private boolean methodIsKnownToBeVoid = false;
    private ParametersMatcher parametersMatcher = ANY_PARAMETERS;
    private Action action = new VoidAction();
    private boolean actionIsDefault = true;
    private List<OrderingConstraint> orderingConstraints = new ArrayList<OrderingConstraint>();
    private List<SideEffect> sideEffects = new ArrayList<SideEffect>();
    private int invocationCount = 0;

    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public void setObjectMatcher(Matcher<?> objectMatcher) {
        this.objectMatcher = objectMatcher;
    }

    public void setMethod(Method method) {
        this.methodMatcher = new MethodMatcher(method);
        this.methodIsKnownToBeVoid = method.getReturnType() == Void.TYPE;
    }

    public void setMethodMatcher(Matcher<? super Method> matcher) {
        this.methodMatcher = matcher;
        this.methodIsKnownToBeVoid = false;
    }

    public void setParametersMatcher(ParametersMatcher parametersMatcher) {
        this.parametersMatcher = parametersMatcher;
    }

    public void addOrderingConstraint(OrderingConstraint orderingConstraint) {
        this.orderingConstraints.add(orderingConstraint);
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.sideEffects.add(sideEffect);
    }

    public void setAction(Action action) {
        this.action = action;
        this.actionIsDefault = false;
    }

    public void setDefaultAction(Action action) {
        this.action = action;
        this.actionIsDefault = true;
    }

    public void describeTo(Description description) {
        if (!this.isSatisfied()) {
            description.appendText("! ");
        }
        this.describeExpectation(description);
    }

    @Override
    public void describeMismatch(Invocation invocation, Description description) {
        this.describeExpectation(description);
        Object[] parameters = invocation.getParametersAsArray();
        if (this.methodMatcher.matches((Object)invocation.getInvokedMethod()) && this.parametersMatcher.isCompatibleWith(parameters)) {
            this.parametersMatcher.describeMismatch(parameters, description);
        }
    }

    private void describeExpectation(Description description) {
        this.describeMethod(description);
        this.parametersMatcher.describeTo(description);
        this.describeSideEffects(description);
    }

    private void describeMethod(Description description) {
        this.cardinality.describeTo(description);
        description.appendText(", ");
        if (this.invocationCount == 0) {
            description.appendText("never invoked");
        } else {
            description.appendText("already invoked ");
            description.appendText(Formatting.times(this.invocationCount));
        }
        description.appendText(": ");
        this.objectMatcher.describeTo(description);
        description.appendText(".");
        this.methodMatcher.describeTo(description);
    }

    private void describeSideEffects(Description description) {
        for (OrderingConstraint orderingConstraint : this.orderingConstraints) {
            description.appendText("; ");
            orderingConstraint.describeTo(description);
        }
        if (!this.shouldSuppressActionDescription()) {
            description.appendText("; ");
            this.action.describeTo(description);
        }
        for (SideEffect sideEffect : this.sideEffects) {
            description.appendText("; ");
            sideEffect.describeTo(description);
        }
    }

    private boolean shouldSuppressActionDescription() {
        return this.methodIsKnownToBeVoid && this.actionIsDefault;
    }

    @Override
    public boolean isSatisfied() {
        return this.cardinality.isSatisfied(this.invocationCount);
    }

    @Override
    public boolean allowsMoreInvocations() {
        return this.cardinality.allowsMoreInvocations(this.invocationCount);
    }

    @Override
    public boolean matches(Invocation invocation) {
        return this.allowsMoreInvocations() && this.objectMatcher.matches(invocation.getInvokedObject()) && this.methodMatcher.matches((Object)invocation.getInvokedMethod()) && this.parametersMatcher.matches(invocation.getParametersAsArray()) && this.isInCorrectOrder();
    }

    private boolean isInCorrectOrder() {
        for (OrderingConstraint constraint : this.orderingConstraints) {
            if (constraint.allowsInvocationNow()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        ++this.invocationCount;
        this.performSideEffects();
        Object result = this.action.invoke(new Invocation(Invocation.ExpectationMode.ASSERTING, invocation));
        invocation.checkReturnTypeCompatibility(result);
        return result;
    }

    private void performSideEffects() {
        for (SideEffect sideEffect : this.sideEffects) {
            sideEffect.perform();
        }
    }

    private static class AnyParametersMatcher
    extends IsAnything<Object[]>
    implements ParametersMatcher {
        public AnyParametersMatcher() {
            super("(<any parameters>)");
        }

        @Override
        public boolean isCompatibleWith(Object[] parameters) {
            return true;
        }
    }
}

