/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.action;

import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;

public class ThrowAction
implements Action {
    private Throwable throwable;

    public ThrowAction(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isThrowingCheckedException()) {
            this.checkTypeCompatiblity(invocation.getInvokedMethod().getExceptionTypes());
        }
        this.throwable.fillInStackTrace();
        throw this.throwable;
    }

    public void describeTo(Description description) {
        description.appendText("throws ");
        description.appendValue((Object)this.throwable);
    }

    private void checkTypeCompatiblity(Class<?>[] allowedExceptionTypes) {
        for (int i = 0; i < allowedExceptionTypes.length; ++i) {
            if (!allowedExceptionTypes[i].isInstance(this.throwable)) continue;
            return;
        }
        this.reportIncompatibleCheckedException(allowedExceptionTypes);
    }

    private void reportIncompatibleCheckedException(Class<?>[] allowedTypes) {
        StringBuffer message = new StringBuffer();
        message.append("tried to throw a ");
        message.append(this.throwable.getClass().getName());
        message.append(" from a method that throws ");
        if (allowedTypes.length == 0) {
            message.append("no exceptions");
        } else {
            for (int i = 0; i < allowedTypes.length; ++i) {
                if (i > 0) {
                    message.append(",");
                }
                message.append(allowedTypes[i].getName());
            }
        }
        throw new IllegalStateException(message.toString());
    }

    private boolean isThrowingCheckedException() {
        return !(this.throwable instanceof RuntimeException) && !(this.throwable instanceof Error);
    }
}

