package museum;

import java.util.Map;

public class ArtMuseum {

  private final Map<String, String> galleries = galleryMap();

  private Map<String, String> galleryMap() {
    return Map.of("Baroque", "Great Hall",
        "Impressionism", "Modern Wing",
        "Expressionism", "East Wing",
        "Renaissance", "West Wing");
  }

  public void locateArtBy(String artist) {
    if (new ArtCollection().containsPaintingBy(artist)) {
      String galleryName = galleries.get(new ArtCollection().paintingBy(artist).style());
      System.out.println("You can find paintings by " + artist + " in the " + galleryName + ".");
    } else {
      System.out.println("There are no paintings by " + artist + " in this museum.");
    }
  }

  public static void main(String[] args) {
    new ArtMuseum().locateArtBy("Vincent van Gogh");
  }
}

