package museum;


import java.util.ArrayList;
import java.util.List;

public class ArtCollection {

  private final List<Painting> paintings = famousPaintings();

  private List<Painting> famousPaintings() {
    return List.of(new Painting("Mona Lisa", "Leonardo da Vinci", "Renaissance"),
                   new Painting("The Starry Night", "Vincent van Gogh", "Impressionism"),
                   new Painting("The Scream", "Edvard Munch", "Expressionism"),
                   new Painting("Venus or Urbino", "Titian", "Renaissance"),
                   new Painting("The Night Watch", "Rembrandt", "Baroque"),
                   new Painting("The Hay Wain", "John Constable", "Romanticism"),
                   new Painting("Westminster Bridge", "Claude Monet", "Impressionism"));
  }

  public boolean containsPaintingBy(String artist) {
    return paintingBy(artist) != null;
  }

  public Painting paintingBy(String artist) {
    return paintings.stream().filter(painting -> painting.artist().equals(artist)).findFirst().orElse(null);
  }

}

