package medicalrecords;


import java.time.LocalDate;

public class PatientBuilder {

  private String id;
  private String name;
  private LocalDate dateOfBirth;

  public static PatientBuilder patient(String id) {
    return new PatientBuilder().withId(id);
  }

  public PatientBuilder withId(String id) {
    this.id = id;
    return this;
  }

  public PatientBuilder named(String name) {
    this.name = name;
    return this;
  }

  public PatientBuilder dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  public Patient build() {
    return new Patient(id, name, dateOfBirth);
  }
}
