package patientapp;

import medicalrecords.Patient;
import surgery.AppointmentSlot;
import surgery.DoctorsSurgery;
import surgery.NoAppointmentsAvailable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class EmergencyConsultation {

  private final Patient patient;
  private AppointmentSlot offeredSlot;

  public EmergencyConsultation(Patient patient) {
    this.patient = patient;
  }

  public AppointmentSlot firstAvailable() {
    DoctorsSurgery surgery = DoctorsSurgery.getInstance();
    LocalDate today = LocalDate.now();
    List<AppointmentSlot> allSlots = new ArrayList<>();
    today.datesUntil(today.plusDays(7)).forEach((date) -> {
       allSlots.addAll(surgery.requestAppointment(date));
    });

    List<AppointmentSlot> potentialSlots = new ArrayList<>();
    for (AppointmentSlot slot : allSlots) {
      // must be later today
      if (slot.date().equals(today) && slot.dateAndTime().isAfter(LocalDateTime.now())) {
        potentialSlots.add(slot);
      }
    }

    potentialSlots.sort(Comparator.comparing(AppointmentSlot::dateAndTime));

    if (potentialSlots.size() > 0) {
      offeredSlot = potentialSlots.get(0);
      return offeredSlot;
    }

    throw new NoAppointmentsAvailable("Nothing available, try another surgery");
  }

  public void confirm() {
    if (offeredSlot != null) {
      DoctorsSurgery.getInstance().confirm(offeredSlot, patient);
    } else {
      throw new NoAppointmentsAvailable("Nothing to confirm.");
    }
  }
}
