package patientapp;

import medicalrecords.Patient;
import surgery.AppointmentSlot;
import surgery.NoAppointmentsAvailable;

import java.time.LocalDate;

import static medicalrecords.PatientBuilder.patient;

public class Example {

  public static void main(String[] args) {

    Patient patient = patient("NHS79448523")
            .named("John Smith")
            .dateOfBirth(LocalDate.of(1975, 05, 22))
            .build();

    WeekendConsultation consultation = new WeekendConsultation(patient);

    try {

      AppointmentSlot appointment = consultation.firstAvailable();
      System.out.println("Got an appointment at " + appointment);

      consultation.confirm();

    } catch (NoAppointmentsAvailable naa) {
      System.out.println("Could not get an appointment");
    }
  }
}
