package surgery;

import java.time.LocalDate;
import java.time.LocalDateTime;

public class AppointmentSlot {

  private final LocalDateTime dateTime;

  public AppointmentSlot(LocalDateTime dateTime) {
    this.dateTime = dateTime;
  }

  public LocalDate date() {
    return dateTime.toLocalDate();
  }

  public LocalDateTime dateAndTime() {
    return dateTime;
  }

  @Override
  public String toString() {
    return "Appointment slot: " + dateTime;
  }
}
