package surgery;

import medicalrecords.Patient;

import java.time.LocalDate;
import java.util.*;

public class DoctorsSurgery {

  private static final DoctorsSurgery INSTANCE = new DoctorsSurgery();

  private final Map<LocalDate, Set<AppointmentSlot>> availableSlots;
  private final Set<ConfirmedAppointment> confirmedAppointments = new HashSet<>();

  private DoctorsSurgery() {
    availableSlots = new HashMap<>();
    LocalDate today = LocalDate.now();
    today.datesUntil(today.plusDays(7)).forEach((day) -> {
      Set<AppointmentSlot> slotsOnDay = new HashSet<>();
      availableSlots.put(day, slotsOnDay);
      for (int h = 9; h < 18; h++) {
        if (lucky()) { slotsOnDay.add(new AppointmentSlot(day.atTime(h, 0))); }
        if (lucky()) { slotsOnDay.add(new AppointmentSlot(day.atTime(h, 15))); }
        if (lucky()) { slotsOnDay.add(new AppointmentSlot(day.atTime(h, 30))); }
        if (lucky()) { slotsOnDay.add(new AppointmentSlot(day.atTime(h, 45))); }
      }
    });
  }

  public static DoctorsSurgery getInstance() {
    return INSTANCE;
  }

  public Set<AppointmentSlot> requestAppointment(LocalDate date) {
    if (availableSlots.containsKey(date)) {
      return Collections.unmodifiableSet(availableSlots.get(date));
    } else {
      return Collections.emptySet();
    }
  }

  public void confirm(AppointmentSlot appointmentSlot, Patient patient) {
    availableSlots.get(appointmentSlot.date()).remove(appointmentSlot);
    confirmedAppointments.add(new ConfirmedAppointment(patient, appointmentSlot.dateAndTime()));
    System.out.println("Confirming appointment for " + patient + " at " + appointmentSlot.dateAndTime());
  }

  private boolean lucky() {
    return Math.random() > 0.5;
  }
}
