package photos;

import java.util.Objects;

public class Photo {

  private final String imageData;

  public Photo(String title) {
    this.imageData = title;
  }

  @Override
  public String toString() {
    return "Photo: " + imageData;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Photo article = (Photo) o;
    return Objects.equals(imageData, article.imageData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(imageData);
  }
}
