/*
 * Decompiled with CFR 0.152.
 */
package com.chatley.magicbeans;

import com.chatley.magicbeans.Adder;
import com.chatley.magicbeans.Binding;
import com.chatley.magicbeans.ByteCodeChecker;
import com.chatley.magicbeans.Component;
import com.chatley.magicbeans.ConfigurationManager;
import com.chatley.magicbeans.DirectoryMonitor;
import com.chatley.magicbeans.FSPDefinition;
import com.chatley.magicbeans.Hole;
import com.chatley.magicbeans.Logger;
import com.chatley.magicbeans.MultiMethod;
import com.chatley.magicbeans.NullLogger;
import com.chatley.magicbeans.ObserverList;
import com.chatley.magicbeans.Peg;
import com.chatley.magicbeans.Strategy;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PluginManager {
    private static boolean GENERATE_DARWIN = true;
    private static String s_host = "127.0.0.1";
    private static PluginManager s_pm = new PluginManager();
    private static Set s_exclusions = new HashSet<String>(Arrays.asList("ListAdder", "Framework", "FSPDefinition", ConfigurationManager.get("frameworkjar")));
    private List o_bindings = new ArrayList();
    private List o_components = new ArrayList();
    private List o_adders = new ArrayList();
    private List o_strategies = new ArrayList();
    private ObserverList o_observers = new ObserverList();
    private Map o_pegs_instantiated = new HashMap();
    private Map o_fsp = new HashMap();
    private ByteCodeChecker o_byteCodeChecker;
    private static Logger o_log;

    private PluginManager() {
        o_log = new NullLogger();
    }

    public static PluginManager getInstance() {
        return s_pm;
    }

    public List get(Object object) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component component = this.getComponent(object);
        if (component == null) {
            return arrayList;
        }
        Iterator iterator = this.o_bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (binding.getFrom() != component) continue;
            arrayList.add(binding.getTo());
        }
        return arrayList;
    }

    private Component getComponent(Object object) {
        try {
            Component component = (Component)object.getClass().getClassLoader();
            return component;
        }
        catch (ClassCastException classCastException) {
            o_log.msg("Class " + object.getClass().getName() + " was not loaded through component mechanism.");
            return null;
        }
    }

    public List get(Object object, String string) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public void addObserver(Object object) {
        o_log.msg("PM --- adding observer" + object.getClass().getName());
        this.o_observers.add(object);
    }

    public void addBackDatedObserver(Object object) {
        this.addObserver(object);
        Iterator iterator = this.o_bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            if (binding.getFrom() != object.getClass().getClassLoader()) continue;
            MultiMethod.dispatch(object, "pluginAdded", binding.getProxy());
        }
    }

    public void bind() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.o_components.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            Iterator iterator2 = this.o_components.iterator();
            while (iterator2.hasNext()) {
                Component component2 = (Component)iterator2.next();
                if (component == component2) continue;
                Iterator iterator3 = component.getPegs().iterator();
                while (iterator3.hasNext()) {
                    Peg peg = (Peg)iterator3.next();
                    Iterator iterator4 = component2.getHoles().iterator();
                    while (iterator4.hasNext()) {
                        Hole hole = (Hole)iterator4.next();
                        if (ConfigurationManager.get("bindpolicy").equals("1-1") && peg.isBound(hole.getInterface()) || !hole.available() || !this.sameShape(peg, hole)) continue;
                        this.makeBinding(new Binding(component2, component, hole, peg));
                    }
                }
            }
        }
    }

    private void makeBinding(Binding binding) {
        binding.getHole().decr();
        binding.getHole().setBound(true);
        binding.getPeg().setBound(binding.getHole().getInterface(), true);
        binding.generateProxy(this.o_pegs_instantiated);
        this.o_bindings.add(binding);
        o_log.msg("PM -- NEW BINDING : " + binding);
        this.notifyObservers(binding);
    }

    public synchronized void add(Component component) {
        this.o_components.add(component);
        this.bind();
        if (ConfigurationManager.get("generatedarwin").equals("true")) {
            new DarwinGenerator().generateDarwin();
        }
    }

    public void add2(Component component) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List<Binding> list;
        Object object6;
        Iterator iterator;
        Object object7;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list2 = component.getPegs();
        Peg peg = null;
        Component component2 = null;
        this.o_components.add(component);
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            peg = (Peg)iterator2.next();
            object7 = this.o_components.iterator();
            while (object7.hasNext()) {
                component2 = (Component)object7.next();
                iterator = component2.getHoles().iterator();
                while (iterator.hasNext()) {
                    object6 = (Hole)iterator.next();
                    if (!((Hole)object6).available() || ((Hole)object6).getName().equals("com.chatley.magicbeans.Notifiable") || !this.sameShape(peg, (Hole)object6)) continue;
                    if (hashMap.get(((Hole)object6).getName()) != null) {
                        list = (List)hashMap.get(((Hole)object6).getName());
                        list.add(new Binding(component2, component, (Hole)object6, peg));
                        continue;
                    }
                    list = new ArrayList<Binding>();
                    list.add(new Binding(component2, component, (Hole)object6, peg));
                    hashMap.put(((Hole)object6).getName(), list);
                }
            }
            iterator = hashMap.values();
            object6 = iterator.iterator();
            while (object6.hasNext()) {
                list = (List)object6.next();
                if (list.size() <= 0) continue;
                object5 = (Binding)list.get(0);
                object4 = list.listIterator(1);
                block4: while (object4.hasNext()) {
                    object3 = (Binding)object4.next();
                    object2 = this.o_strategies.iterator();
                    while (object2.hasNext()) {
                        object = ((Strategy)object2.next()).prefer((Binding)object5, (Binding)object3);
                        if (object == null) continue;
                        object5 = object;
                        continue block4;
                    }
                }
                ((Binding)object5).getHole().decr();
                ((Binding)object5).getHole().setBound(true);
                ((Binding)object5).generateProxy(this.o_pegs_instantiated);
                this.o_bindings.add(object5);
                o_log.msg("NEW BINDING : " + object5);
            }
        }
        hashMap = new HashMap();
        object7 = component.getHoles();
        iterator = object7.iterator();
        while (iterator.hasNext()) {
            object6 = (Hole)iterator.next();
            list = this.o_components.iterator();
            while (list.hasNext()) {
                component2 = (Component)list.next();
                object5 = component2.getPegs().iterator();
                while (object5.hasNext()) {
                    peg = (Peg)object5.next();
                    if (!((Hole)object6).available() || ((Hole)object6).getName().equals("com.chatley.magicbeans.Notifiable") || !this.sameShape(peg, (Hole)object6)) continue;
                    if (hashMap.get(((Hole)object6).getName()) != null) {
                        object4 = (List)hashMap.get(((Hole)object6).getName());
                        object4.add(new Binding(component2, component, (Hole)object6, peg));
                        continue;
                    }
                    object4 = new ArrayList();
                    object4.add(new Binding(component2, component, (Hole)object6, peg));
                    hashMap.put(((Hole)object6).getName(), object4);
                }
            }
            object5 = hashMap.values();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (List)object4.next();
                if (object3.size() <= 0) continue;
                object2 = (Binding)object3.get(0);
                object = object3.listIterator(1);
                block10: while (object.hasNext()) {
                    Binding binding = (Binding)object.next();
                    Iterator iterator3 = this.o_strategies.iterator();
                    while (iterator3.hasNext()) {
                        Binding binding2 = ((Strategy)iterator3.next()).prefer((Binding)object2, binding);
                        if (binding2 == null) continue;
                        object2 = binding2;
                        continue block10;
                    }
                }
                ((Binding)object2).getHole().decr();
                ((Binding)object2).generateProxy(this.o_pegs_instantiated);
                this.o_bindings.add(object2);
                o_log.msg("NEW BINDING : " + object2);
            }
        }
    }

    public void remove(Component component) {
        Object object;
        o_log.msg("about to remove component " + component);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.o_bindings.iterator();
        while (iterator.hasNext()) {
            object = (Binding)iterator.next();
            if (((Binding)object).getTo().equals(component)) {
                arrayList.add(object);
                iterator.remove();
            }
            if (!((Binding)object).getFrom().equals(component)) continue;
            ((Binding)object).getPeg().setBound(((Binding)object).getHole().getInterface(), false);
            ((Binding)object).getHole().incr();
            iterator.remove();
        }
        object = this.o_observers.clonelist();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Iterator iterator3 = arrayList.iterator();
            while (iterator3.hasNext()) {
                Binding binding = (Binding)iterator3.next();
                if (binding.getFrom() == component || !binding.getFrom().equals(e.getClass().getClassLoader()) && !binding.getFrom().getName().equals("framework.jar")) continue;
                o_log.msg("notifying " + e);
                MultiMethod.dispatch(e, "pluginRemoved", binding.getProxy());
                binding.disconnect();
            }
        }
        this.o_components.remove(component);
        this.bind();
        o_log.msg("removed " + component);
    }

    public void replace(Component component, Component component2) {
    }

    private void notifyObservers(Binding binding) {
        if (binding.getFrom().getName().endsWith(ConfigurationManager.get("frameworkjar"))) {
            MultiMethod.dispatch(this, "pluginAdded", binding.getProxy());
        } else {
            List list = this.o_observers.clonelist();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e.getClass().getClassLoader() != binding.getFrom()) continue;
                MultiMethod.dispatch(e, "pluginAdded", binding.getProxy());
            }
        }
    }

    private boolean sameShape(Peg peg, Hole hole) {
        try {
            Class<?> clazz = Class.forName(peg.getName(), false, peg.getComponent());
            Class<?> clazz2 = Class.forName(hole.getName(), false, hole.getComponent());
            if (clazz2.isAssignableFrom(clazz)) {
                o_log.msg(clazz2 + " : " + clazz + clazz2.isAssignableFrom(clazz));
            }
            return clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void register(Component component) {
        o_log.msg("adding component " + component.getName());
        this.o_components.add(component);
    }

    public Component getLastComponent() {
        if (this.o_components.size() > 0) {
            return (Component)this.o_components.get(this.o_components.size() - 1);
        }
        return null;
    }

    public DarwinGenerator getDarwinGenerator(boolean bl) {
        return new DarwinGenerator(bl);
    }

    public void pluginAdded(Strategy strategy) {
        this.o_strategies.add(strategy);
        o_log.msg("********** added Strategy ***********");
    }

    public void pluginAdded(Adder adder) {
        this.o_adders.add(adder);
        o_log.msg("********** added Adder **************");
        new Thread(adder).start();
    }

    public void pluginAdded(Logger logger) {
        o_log = logger;
        o_log.msg("new logger added");
    }

    public void pluginAdded(FSPDefinition fSPDefinition) {
        if (this.o_fsp.get(fSPDefinition.getClass().getClassLoader()) == null) {
            this.o_fsp.put(fSPDefinition.getClass().getClassLoader(), new ArrayList());
        }
        List list = (List)this.o_fsp.get(fSPDefinition.getClass().getClassLoader());
        list.add(fSPDefinition.getFSP());
        o_log.msg("PM - adding FSP def : " + fSPDefinition.getFSP());
    }

    public void pluginRemoved(Object object) {
        if (object instanceof Strategy) {
            this.o_strategies.remove(object);
            o_log.msg("********** remove Strategy ***********");
        } else {
            o_log.msg("can't remove " + object);
        }
    }

    public static void main(String[] stringArray) {
        try {
            ConfigurationManager.configure(stringArray[0]);
            Component component = new Component(ConfigurationManager.get("frameworkjar"), s_pm.getClass().getClassLoader());
            s_pm.addObserver(s_pm);
            Component component2 = new Component(ConfigurationManager.get("targetjar"), component);
            s_pm.register(component);
            s_pm.register(component2);
            s_pm.bind();
            DirectoryMonitor directoryMonitor = new DirectoryMonitor("plugins", ConfigurationManager.get("pollpluginsdir").equals("true"));
            new Thread(directoryMonitor).start();
            try {
                o_log.msg("about to load mainclass");
                Class<?> clazz = Class.forName(ConfigurationManager.get("targetclass"), true, component2);
                o_log.msg("done");
                Method method = clazz.getMethod("main", stringArray.getClass());
                method.invoke(null, new Object[]{new String[0]});
            }
            catch (ClassNotFoundException classNotFoundException) {
                o_log.error("Class not found in application");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                o_log.error("Class does not have a main method");
            }
            catch (IllegalAccessException illegalAccessException) {
                o_log.error(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                o_log.error("Inv err" + invocationTargetException + invocationTargetException.getCause());
                invocationTargetException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class DarwinGenerator {
        private PrintStream o_darwinstream;
        private Socket o_socket;
        private PrintStream o_darwinoutput = null;
        private ByteArrayOutputStream o_baos;
        private Map o_ports;
        private Map o_binding_constants;
        private OutputStream os = null;
        private Set o_interfaces;
        private Map o_requires;

        DarwinGenerator() {
            this(true);
        }

        DarwinGenerator(boolean bl) {
            if (PluginManager.this.o_byteCodeChecker == null) {
                PluginManager.this.o_byteCodeChecker = new ByteCodeChecker();
            }
            this.o_ports = new HashMap();
            this.o_requires = new HashMap();
            this.o_interfaces = new HashSet();
            this.o_binding_constants = new HashMap();
            this.o_baos = new ByteArrayOutputStream();
            this.o_darwinstream = new PrintStream(this.o_baos);
            if (bl) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(ConfigurationManager.get("ltsaIP"));
                    this.o_socket = new Socket(inetAddress, 5555);
                    this.os = this.o_socket.getOutputStream();
                    this.o_darwinoutput = new PrintStream(this.os);
                }
                catch (Exception exception) {
                    o_log.error(exception.getMessage());
                }
            }
        }

        public void generateDarwin() {
            Iterator iterator;
            Object object;
            Object object2;
            Object object3;
            if (this.os == null) {
                return;
            }
            HashSet<Component> hashSet = new HashSet<Component>();
            HashMap<String, Hole> hashMap = new HashMap<String, Hole>();
            Iterator iterator2 = PluginManager.this.o_bindings.iterator();
            while (iterator2.hasNext()) {
                object3 = (Binding)iterator2.next();
                if (this.exclude(this.lastPart(((Binding)object3).getTo().getName())) || this.exclude(this.lastPart(((Binding)object3).getFrom().getName()))) continue;
                hashSet.add(((Binding)object3).getTo());
                hashSet.add(((Binding)object3).getFrom());
                hashMap.put(((Binding)object3).getHole().getName(), ((Binding)object3).getHole());
                this.o_interfaces.add(((Binding)object3).getHole().getName());
            }
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (Hole)hashMap.get(object2);
                this.o_darwinstream.print("interface " + this.lastPart(((Hole)object).getName()) + " { ");
                iterator = ((Hole)object).getMethods().iterator();
                while (iterator.hasNext()) {
                    this.o_darwinstream.print(iterator.next() + "; ");
                }
                this.o_darwinstream.println("}\n");
            }
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object = (Component)object2.next();
                if (this.exclude(((Component)object).getName())) continue;
                iterator = this.toProcessName(((Component)object).getName());
                this.o_darwinstream.println("component " + iterator + " {");
                this.printRequires((Component)object);
                this.printProvides((Component)object);
                this.printBehaviour((Component)object);
                this.o_darwinstream.println("}\n");
            }
            this.o_darwinstream.println("component System {");
            char c = 'a';
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                String string = this.toProcessName(component.getName());
                this.o_ports.put(component, new Character(c));
                char c2 = c;
                c = (char)(c + '\u0001');
                this.o_darwinstream.println("\t inst " + c2 + ":" + string + ";");
            }
            this.printBindings();
            this.o_darwinstream.println("}");
            this.o_darwinoutput.println("\n" + this.o_baos.toString() + "\n");
            this.o_darwinoutput.flush();
            this.o_darwinoutput.close();
            try {
                this.os.flush();
                this.os.close();
                this.o_socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String analyseComponent(Component component) {
            this.o_baos = new ByteArrayOutputStream();
            this.o_darwinstream = new PrintStream(this.o_baos);
            String string = this.toProcessName(component.getName());
            this.checkInterfaces(component);
            this.o_darwinstream.println("component " + string + " {");
            this.printRequires(component);
            this.printProvides(component);
            this.printBehaviour(component);
            this.o_darwinstream.println("}\n");
            return "\n" + this.o_baos.toString() + "\n";
        }

        private void checkInterfaces(Component component) {
            Object object;
            Iterator iterator = component.getHoles().iterator();
            while (iterator.hasNext()) {
                object = (Hole)iterator.next();
                this.o_interfaces.add(((Hole)object).getName());
            }
            object = component.getPegs().iterator();
            while (object.hasNext()) {
                Peg peg = (Peg)object.next();
                this.o_interfaces.add(peg.getName());
            }
        }

        String getBehaviour(Component component) {
            try {
                Class<?> clazz = Class.forName("com.chatley.magicbeans.FSPDefinition");
                Iterator iterator = component.getPegs().iterator();
                while (iterator.hasNext()) {
                    Peg peg = (Peg)iterator.next();
                    Iterator iterator2 = peg.getImplementedInterfaces().iterator();
                    while (iterator2.hasNext()) {
                        Class clazz2 = (Class)iterator2.next();
                        if (!clazz.isAssignableFrom(clazz2)) continue;
                        Class<?> clazz3 = Class.forName(peg.getName(), true, component);
                        FSPDefinition fSPDefinition = (FSPDefinition)clazz3.newInstance();
                        return fSPDefinition.getFSP();
                    }
                }
            }
            catch (Exception exception) {
                o_log.error(exception.getMessage());
            }
            return "";
        }

        Set getAllActions(Component component) {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = component.getPegs().iterator();
            while (iterator.hasNext()) {
                object = (Peg)iterator.next();
                hashSet.addAll(((Peg)object).getMethods());
            }
            object = this.o_requires.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Iterator iterator2 = ((Hole)this.o_requires.get(string)).getMethods().iterator();
                while (iterator2.hasNext()) {
                    hashSet.add(string + "." + (String)iterator2.next());
                }
            }
            return hashSet;
        }

        private boolean exclude(String string) {
            if (string == null) {
                return true;
            }
            boolean bl = false;
            Iterator iterator = s_exclusions.iterator();
            while (iterator.hasNext()) {
                String string2 = this.lastPart(this.toProcessName(string));
                bl |= string2.equalsIgnoreCase((String)iterator.next());
            }
            return bl;
        }

        String getProcessName(Component component) {
            return this.toProcessName(component.getName());
        }

        private String toProcessName(String string) {
            String string2 = string.indexOf("\\") > -1 ? string.substring(string.lastIndexOf("\\") + 1, string.lastIndexOf(".")) : (string.indexOf(".") > -1 ? string.substring(0, string.lastIndexOf(".")) : string);
            return string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
        }

        private void printBindings() {
            Iterator iterator = PluginManager.this.o_bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                if (this.exclude(this.lastPart(binding.getTo().getName())) || this.exclude(this.lastPart(binding.getFrom().getName()))) continue;
                this.o_darwinstream.println("\t bind " + this.o_ports.get(binding.getTo()) + "." + this.lastPart(binding.getHole().getName()) + " -- " + this.o_ports.get(binding.getFrom()) + "." + this.o_ports.get(binding.getFrom().getName() + binding.getHole().getName()) + ";");
            }
        }

        void printRequires(Component component) {
            int n = 97;
            Iterator iterator = component.getHoles().iterator();
            while (iterator.hasNext()) {
                Hole hole = (Hole)iterator.next();
                Class clazz = hole.getDeclaringClass();
                Field[] fieldArray = clazz.getDeclaredFields();
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    Class<?> clazz2 = fieldArray[n2].getType();
                    if (clazz2.isAssignableFrom(hole.getInterface()) && PluginManager.this.o_byteCodeChecker.inByteCode(component, clazz.getName(), fieldArray[n2].getName())) {
                        this.o_ports.put(component.getName() + hole.getName(), fieldArray[n2].getName());
                        this.o_requires.put(fieldArray[n2].getName(), hole);
                        this.o_darwinstream.println("\t require " + fieldArray[n2].getName() + ":" + this.lastPart(hole.getName()) + ";");
                    }
                    ++n2;
                }
            }
        }

        void printProvides(Component component) {
            Iterator iterator = component.getPegs().iterator();
            while (iterator.hasNext()) {
                Peg peg = (Peg)iterator.next();
                Iterator iterator2 = peg.getImplementedInterfaces().iterator();
                while (iterator2.hasNext()) {
                    String string = ((Class)iterator2.next()).getName();
                    if (!this.o_interfaces.contains(string)) continue;
                    if (this.o_ports.get(component.getName() + string) == null) {
                        this.o_ports.put(component.getName() + string, new Character('c'));
                    }
                    this.o_darwinstream.println("\t provide " + this.lastPart(string) + ";");
                }
            }
        }

        private String lastPart(String string) {
            String string2 = string.trim();
            if (string2.endsWith(".jar")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            if (string2.indexOf(".") > -1) {
                string2 = string2.substring(string2.lastIndexOf(".") + 1, string2.length());
            }
            if (string2.indexOf("\\") > -1) {
                string2 = string2.substring(string2.lastIndexOf("\\") + 1, string2.length());
            }
            return string2;
        }

        private void printBehaviour(Component component) {
            List list = (List)PluginManager.this.o_fsp.get(component);
            if (list != null) {
                this.o_darwinstream.println("\t/%");
                int n = 1;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    o_log.msg("printBehaviour : " + n++);
                    String string = (String)iterator.next();
                    this.o_darwinstream.println("\t" + string.trim());
                }
                this.o_darwinstream.println("\t%/");
            } else {
                Object object;
                HashSet hashSet = new HashSet();
                String string = this.toProcessName(component.getName());
                this.o_darwinstream.println("\t/%");
                this.o_darwinstream.print("\t" + string + " = ( ");
                Iterator iterator = component.getPegs().iterator();
                while (iterator.hasNext()) {
                    object = (Peg)iterator.next();
                    hashSet.addAll(((Peg)object).getMethods());
                }
                object = hashSet.iterator();
                if (hashSet.size() > 1) {
                    this.o_darwinstream.print("{ ");
                    if (object.hasNext()) {
                        this.o_darwinstream.print(object.next());
                    }
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        if (string2.equals("set")) continue;
                        this.o_darwinstream.print(", " + string2);
                    }
                    this.o_darwinstream.println(" } -> " + string + ").\n\t%/");
                } else if (hashSet.size() == 1) {
                    this.o_darwinstream.println(object.next() + " -> " + string + " ).\n\t%/");
                }
            }
        }
    }
}

