/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.Method;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassParser {
    private static final int BUFSIZE = 8192;
    private DataInputStream file;
    private ZipFile zip;
    private String file_name;
    private int class_name_index;
    private int superclass_name_index;
    private int major;
    private int minor;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private boolean is_zip;

    public final JavaClass parse() throws IOException, ClassFormatError {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        this.file.close();
        if (this.zip != null) {
            this.zip.close();
        }
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, this.constant_pool, this.interfaces, this.fields, this.methods, this.attributes, this.is_zip ? (byte)3 : 2);
    }

    private final void readAttributes() throws IOException, ClassFormatError {
        int n = this.file.readUnsignedShort();
        this.attributes = new Attribute[n];
        int n2 = 0;
        while (n2 < n) {
            this.attributes[n2] = Attribute.readAttribute(this.file, this.constant_pool);
            ++n2;
        }
    }

    private final void readClassInfo() throws IOException, ClassFormatError {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatError("Class can't be both final and abstract");
        }
        this.class_name_index = this.file.readUnsignedShort();
        this.superclass_name_index = this.file.readUnsignedShort();
    }

    private final void readConstantPool() throws IOException, ClassFormatError {
        this.constant_pool = new ConstantPool(this.file);
    }

    private final void readFields() throws IOException, ClassFormatError {
        int n = this.file.readUnsignedShort();
        this.fields = new Field[n];
        int n2 = 0;
        while (n2 < n) {
            this.fields[n2] = new Field(this.file, this.constant_pool);
            ++n2;
        }
    }

    private final void readID() throws IOException, ClassFormatError {
        int n = -889275714;
        if (this.file.readInt() != n) {
            throw new ClassFormatError(this.file_name + " is not a Java .class file");
        }
    }

    private final void readInterfaces() throws IOException, ClassFormatError {
        int n = this.file.readUnsignedShort();
        this.interfaces = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.interfaces[n2] = this.file.readUnsignedShort();
            ++n2;
        }
    }

    private final void readMethods() throws IOException, ClassFormatError {
        int n = this.file.readUnsignedShort();
        this.methods = new Method[n];
        int n2 = 0;
        while (n2 < n) {
            this.methods[n2] = new Method(this.file, this.constant_pool);
            ++n2;
        }
    }

    private final void readVersion() throws IOException, ClassFormatError {
        this.minor = this.file.readUnsignedShort();
        this.major = this.file.readUnsignedShort();
    }

    public ClassParser(InputStream inputStream, String string) {
        this.file_name = string;
        String string2 = inputStream.getClass().getName();
        this.is_zip = string2.startsWith("java.util.zip.") || string2.startsWith("java.util.jar.");
        this.file = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(String string) throws IOException {
        this.is_zip = false;
        this.file_name = string;
        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 8192));
    }

    public ClassParser(String string, String string2) throws IOException {
        this.is_zip = true;
        this.zip = new ZipFile(string);
        ZipEntry zipEntry = this.zip.getEntry(string2);
        this.file_name = string2;
        this.file = new DataInputStream(new BufferedInputStream(this.zip.getInputStream(zipEntry), 8192));
    }
}

