/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantObject;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantClass
extends Constant
implements ConstantObject {
    private int name_index;

    public final void accept(Visitor visitor) {
        visitor.visitConstantClass(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.name_index);
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public final String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }

    public final String toString() {
        return super.toString() + "(name_index = " + this.name_index + ")";
    }

    public ConstantClass(ConstantClass constantClass) {
        this(constantClass.getNameIndex());
    }

    ConstantClass(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantClass(int n) {
        super((byte)7);
        this.name_index = n;
    }
}

