/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public final void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int n) {
        this.constantvalue_index = n;
    }

    public final String toString() throws InternalError {
        String string;
        Constant constant = this.constant_pool.getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.constant_pool.getConstant(n, (byte)1);
                string = "\"" + ConstantValue.convertString(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            default: {
                throw new InternalError("Type of ConstValue invalid: " + constant);
            }
        }
        return string;
    }

    private static final String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.constant_pool = constantPool;
        return constantValue;
    }

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)1, n, n2, constantPool);
        this.constantvalue_index = n3;
    }
}

