/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.FieldOrMethod;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Field
extends FieldOrMethod {
    public final void accept(Visitor visitor) {
        visitor.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n].getTag() == 1) {
                return (ConstantValue)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        string = string.equals("") ? "" : string + " ";
        String string2 = Utility.signatureToString(this.getSignature());
        String string3 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string + string2 + " " + string3);
        ConstantValue constantValue = this.getConstantValue();
        if (constantValue != null) {
            stringBuffer.append(" = " + constantValue);
        }
        int n = 0;
        while (n < this.attributes_count) {
            Attribute attribute = this.attributes[n];
            if (!(attribute instanceof ConstantValue)) {
                stringBuffer.append(" [" + attribute.toString() + "]");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public final Field copy(ConstantPool constantPool) {
        return (Field)this.copy_(constantPool);
    }

    public Field(Field field) {
        super(field);
    }

    Field(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatError {
        super(dataInputStream, constantPool);
    }

    public Field(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }
}

