/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumberTable
extends Attribute {
    private int line_number_table_length;
    private LineNumber[] line_number_table;

    public final void accept(Visitor visitor) {
        visitor.visitLineNumberTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.line_number_table_length);
        int n = 0;
        while (n < this.line_number_table_length) {
            this.line_number_table[n].dump(dataOutputStream);
            ++n;
        }
    }

    public final LineNumber[] getLineNumberTable() {
        return this.line_number_table;
    }

    public final void setLineNumberTable(LineNumber[] lineNumberArray) {
        this.line_number_table = lineNumberArray;
        this.line_number_table_length = lineNumberArray == null ? 0 : lineNumberArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < this.line_number_table_length) {
            stringBuffer2.append(this.line_number_table[n].toString());
            if (n < this.line_number_table_length - 1) {
                stringBuffer2.append(", ");
            }
            if (stringBuffer2.length() > 72) {
                stringBuffer2.append('\n');
                stringBuffer.append((Object)stringBuffer2);
                stringBuffer2.setLength(0);
            }
            ++n;
        }
        stringBuffer.append((Object)stringBuffer2);
        return stringBuffer.toString();
    }

    public final int getSourceLine(int n) {
        int n2 = 0;
        int n3 = this.line_number_table_length - 1;
        if (n3 < 0) {
            return -1;
        }
        int n4 = -1;
        int n5 = -1;
        do {
            int n6;
            int n7;
            if ((n7 = this.line_number_table[n6 = (n2 + n3) / 2].getStartPC()) == n) {
                return this.line_number_table[n6].getLineNumber();
            }
            if (n < n7) {
                n3 = n6 - 1;
            } else {
                n2 = n6 + 1;
            }
            if (n7 >= n || n7 <= n5) continue;
            n5 = n7;
            n4 = n6;
        } while (n2 <= n3);
        return this.line_number_table[n4].getLineNumber();
    }

    public final Attribute copy(ConstantPool constantPool) {
        LineNumberTable lineNumberTable = (LineNumberTable)this.clone();
        lineNumberTable.line_number_table = new LineNumber[this.line_number_table_length];
        int n = 0;
        while (n < this.line_number_table_length) {
            lineNumberTable.line_number_table[n] = this.line_number_table[n].copy();
            ++n;
        }
        lineNumberTable.constant_pool = constantPool;
        return lineNumberTable;
    }

    public final int getTableLength() {
        return this.line_number_table_length;
    }

    public LineNumberTable(LineNumberTable lineNumberTable) {
        this(lineNumberTable.getNameIndex(), lineNumberTable.getLength(), lineNumberTable.getLineNumberTable(), lineNumberTable.getConstantPool());
    }

    public LineNumberTable(int n, int n2, LineNumber[] lineNumberArray, ConstantPool constantPool) {
        super((byte)4, n, n2, constantPool);
        this.setLineNumberTable(lineNumberArray);
    }

    LineNumberTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (LineNumber[])null, constantPool);
        this.line_number_table_length = dataInputStream.readUnsignedShort();
        this.line_number_table = new LineNumber[this.line_number_table_length];
        int n3 = 0;
        while (n3 < this.line_number_table_length) {
            this.line_number_table[n3] = new LineNumber(dataInputStream);
            ++n3;
        }
    }
}

