/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private int local_variable_table_length;
    private LocalVariable[] local_variable_table;

    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_table_length);
        int n = 0;
        while (n < this.local_variable_table_length) {
            this.local_variable_table[n].dump(dataOutputStream);
            ++n;
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    public final LocalVariable getLocalVariable(int n) {
        int n2 = 0;
        while (n2 < this.local_variable_table_length) {
            if (this.local_variable_table[n2].getIndex() == n) {
                return this.local_variable_table[n2];
            }
            ++n2;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_table = localVariableArray;
        this.local_variable_table_length = localVariableArray == null ? 0 : localVariableArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.local_variable_table_length) {
            stringBuffer.append(this.local_variable_table[n].toString());
            if (n < this.local_variable_table_length - 1) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.clone();
        localVariableTable.local_variable_table = new LocalVariable[this.local_variable_table_length];
        int n = 0;
        while (n < this.local_variable_table_length) {
            localVariableTable.local_variable_table[n] = this.local_variable_table[n].copy();
            ++n;
        }
        localVariableTable.constant_pool = constantPool;
        return localVariableTable;
    }

    public final int getTableLength() {
        return this.local_variable_table_length;
    }

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    public LocalVariableTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n, n2, constantPool);
        this.setLocalVariableTable(localVariableArray);
    }

    LocalVariableTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        this.local_variable_table_length = dataInputStream.readUnsignedShort();
        this.local_variable_table = new LocalVariable[this.local_variable_table_length];
        int n3 = 0;
        while (n3 < this.local_variable_table_length) {
            this.local_variable_table[n3] = new LocalVariable(dataInputStream, constantPool);
            ++n3;
        }
    }
}

