/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.ReferenceType;
import de.fub.bytecode.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public final Type getBasicType() {
        return this.basic_type;
    }

    public final Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public final int getDimensions() {
        return this.dimensions;
    }

    public final int hashcode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    public final boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.dimensions == this.dimensions && arrayType.basic_type.equals(this.basic_type);
        }
        return false;
    }

    public ArrayType(byte by, int n) {
        this(BasicType.getType(by), n);
    }

    public ArrayType(String string, int n) {
        this(new ObjectType(string), n);
    }

    public ArrayType(Type type, int n) {
        super((byte)13, "<dummy>");
        Object object;
        if (n < 1 || n > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n);
        }
        switch (type.getType()) {
            case 13: {
                object = (ArrayType)type;
                this.dimensions = n + ((ArrayType)object).dimensions;
                this.basic_type = ((ArrayType)object).basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n;
                this.basic_type = type;
                break;
            }
        }
        object = new StringBuffer();
        int n2 = 0;
        while (n2 < this.dimensions) {
            ((StringBuffer)object).append('[');
            ++n2;
        }
        ((StringBuffer)object).append(this.basic_type.getSignature());
        this.signature = ((StringBuffer)object).toString();
    }
}

