/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ConstantPushInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class BIPUSH
extends Instruction
implements ConstantPushInstruction {
    private byte b;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeByte(this.b);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.b;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.length = (short)2;
        this.b = byteSequence.readByte();
    }

    public Number getValue() {
        return new Integer(this.b);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.BYTE;
    }

    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitBIPUSH(this);
    }

    BIPUSH() {
    }

    public BIPUSH(byte by) {
        super((short)16, (short)2);
        this.b = by;
    }
}

