/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.AccessFlags;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ClassObserver;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.INVOKESPECIAL;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.MethodGen;
import de.fub.bytecode.generic.Type;
import java.util.Enumeration;
import java.util.Vector;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private Vector field_vec = new Vector();
    private Vector method_vec = new Vector();
    private Vector attribute_vec = new Vector();
    private Vector interface_vec = new Vector();
    private Vector observers;

    public JavaClass getJavaClass() {
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        Attribute[] attributeArray = this.getAttributes();
        ConstantPool constantPool = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, constantPool, nArray, fieldArray, methodArray, attributeArray);
    }

    public void addInterface(String string) {
        this.interface_vec.addElement(string);
    }

    public void removeInterface(String string) {
        this.interface_vec.removeElement(string);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute attribute) {
        this.attribute_vec.addElement(attribute);
    }

    public void addMethod(Method method) {
        this.method_vec.addElement(method);
    }

    public void addEmptyConstructor(int n) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConstants.THIS);
        instructionList.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        instructionList.append(InstructionConstants.RETURN);
        MethodGen methodGen = new MethodGen(n, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, instructionList, this.cp);
        methodGen.setMaxStack(1);
        this.addMethod(methodGen.getMethod());
    }

    public void addField(Field field) {
        this.field_vec.addElement(field);
    }

    public boolean containsField(Field field) {
        return this.field_vec.contains(field);
    }

    public Field containsField(String string) {
        Enumeration enumeration = this.field_vec.elements();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string, String string2) {
        Enumeration enumeration = this.method_vec.elements();
        while (enumeration.hasMoreElements()) {
            Method method = (Method)enumeration.nextElement();
            if (!method.getName().equals(string) || !method.getSignature().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute attribute) {
        this.attribute_vec.removeElement(attribute);
    }

    public void removeMethod(Method method) {
        this.method_vec.removeElement(method);
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.method_vec.indexOf(method);
        if (n < 0) {
            this.method_vec.addElement(method2);
        } else {
            this.method_vec.setElementAt(method2, n);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.field_vec.indexOf(field);
        if (n < 0) {
            this.field_vec.addElement(field2);
        } else {
            this.field_vec.setElementAt(field2, n);
        }
    }

    public void removeField(Field field) {
        this.field_vec.removeElement(field);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String string) {
        this.class_name = string.replace('/', '.');
        this.class_name_index = this.cp.addClass(string);
    }

    public void setSuperclassName(String string) {
        this.super_class_name = string.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(string);
    }

    public Method[] getMethods() {
        Object[] objectArray = new Method[this.method_vec.size()];
        this.method_vec.copyInto(objectArray);
        return objectArray;
    }

    public void setMethods(Method[] methodArray) {
        this.method_vec.removeAllElements();
        int n = 0;
        while (n < methodArray.length) {
            this.addMethod(methodArray[n]);
            ++n;
        }
    }

    public void setMethodAt(Method method, int n) {
        this.method_vec.setElementAt(method, n);
    }

    public Method getMethodAt(int n) {
        return (Method)this.method_vec.elementAt(n);
    }

    public String[] getInterfaceNames() {
        int n = this.interface_vec.size();
        Object[] objectArray = new String[n];
        this.interface_vec.copyInto(objectArray);
        return objectArray;
    }

    public int[] getInterfaces() {
        int n = this.interface_vec.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.cp.addClass((String)this.interface_vec.elementAt(n2));
            ++n2;
        }
        return nArray;
    }

    public Field[] getFields() {
        Object[] objectArray = new Field[this.field_vec.size()];
        this.field_vec.copyInto(objectArray);
        return objectArray;
    }

    public Attribute[] getAttributes() {
        Object[] objectArray = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.copyInto(objectArray);
        return objectArray;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public void setClassNameIndex(int n) {
        this.class_name_index = n;
        this.class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int n) {
        this.superclass_name_index = n;
        this.super_class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver classObserver) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.addElement(classObserver);
    }

    public void removeObserver(ClassObserver classObserver) {
        if (this.observers != null) {
            this.observers.removeElement(classObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((ClassObserver)enumeration.nextElement()).notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    static /* synthetic */ int access$0(ClassGen classGen) {
        return classGen.access_flags;
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray) {
        this.class_name = string;
        this.super_class_name = string2;
        this.file_name = string3;
        this.access_flags = n;
        this.cp = new ConstantPoolGen();
        this.addAttribute(new SourceFile(this.cp.addUtf8("SourceFile"), 2, this.cp.addUtf8(string3), this.cp.getConstantPool()));
        this.class_name_index = this.cp.addClass(string);
        this.superclass_name_index = this.cp.addClass(string2);
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.addInterface(stringArray[n2]);
                ++n2;
            }
        }
    }

    public ClassGen(JavaClass javaClass) {
        this.class_name_index = javaClass.getClassNameIndex();
        this.superclass_name_index = javaClass.getSuperclassNameIndex();
        this.class_name = javaClass.getClassName();
        this.super_class_name = javaClass.getSuperclassName();
        this.file_name = javaClass.getSourceFileName();
        this.access_flags = javaClass.getAccessFlags();
        this.cp = new ConstantPoolGen(javaClass.getConstantPool());
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Attribute[] attributeArray = javaClass.getAttributes();
        Method[] methodArray = javaClass.getMethods();
        Field[] fieldArray = javaClass.getFields();
        String[] stringArray = javaClass.getInterfaceNames();
        int n = 0;
        while (n < stringArray.length) {
            this.addInterface(stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < attributeArray.length) {
            this.addAttribute(attributeArray[n]);
            ++n;
        }
        n = 0;
        while (n < methodArray.length) {
            this.addMethod(methodArray[n]);
            ++n;
        }
        n = 0;
        while (n < fieldArray.length) {
            this.addField(fieldArray[n]);
            ++n;
        }
    }
}

