/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.LocalVariableInstruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends LocalVariableInstruction {
    private boolean wide;
    private int c;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.n);
            dataOutputStream.writeShort(this.c);
        } else {
            dataOutputStream.writeByte(this.n);
            dataOutputStream.writeByte(this.c);
        }
    }

    private final void setWide() {
        this.wide = this.n > 65535 || Math.abs(this.c) > 127;
        this.length = this.wide ? (short)6 : (short)3;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.wide = bl;
        if (bl) {
            this.length = (short)6;
            this.n = byteSequence.readUnsignedShort();
            this.c = byteSequence.readShort();
        } else {
            this.length = (short)3;
            this.n = byteSequence.readUnsignedByte();
            this.c = byteSequence.readByte();
        }
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.c;
    }

    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.n = n;
        this.setWide();
    }

    public final int getIncrement() {
        return this.c;
    }

    public final void setIncrement(int n) {
        this.c = n;
        this.setWide();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.INT;
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariableInstruction(this);
        visitor.visitIINC(this);
    }

    IINC() {
    }

    public IINC(int n, int n2) {
        this.opcode = (short)132;
        this.length = (short)3;
        this.setIndex(n);
        this.setIncrement(n2);
    }
}

