/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.generic.BranchHandle;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.CPInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeExceptionGen;
import de.fub.bytecode.generic.CompoundInstruction;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionListObserver;
import de.fub.bytecode.generic.LocalVariableGen;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TargetLostException;
import de.fub.bytecode.util.ByteSequence;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InstructionList
implements Serializable {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;
    private Vector observers;

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] instructionHandleArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n - 1;
        do {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = (n3 + n4) / 2]) == n2) {
                return instructionHandleArray[n5];
            }
            if (n2 < n6) {
                n4 = n5 - 1;
                continue;
            }
            n3 = n5 + 1;
        } while (n3 <= n4);
        return null;
    }

    public InstructionHandle findHandle(int n) {
        InstructionHandle[] instructionHandleArray = this.getInstructionHandles();
        return InstructionList.findHandle(instructionHandleArray, this.byte_positions, this.length, n);
    }

    public InstructionHandle append(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.next;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.next = instructionList.start;
        instructionList.start.prev = instructionHandle;
        instructionList.end.next = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.prev = instructionList.end;
        } else {
            this.end = instructionList.end;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle append(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction2(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.append(instructionHandle, instructionList);
    }

    public InstructionHandle append(InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = instructionList.start;
            this.end = instructionList.end;
            this.length = instructionList.length;
            instructionList.clear();
            return this.start;
        }
        return this.append(this.end, instructionList);
    }

    private final void append(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.end.next = instructionHandle;
            instructionHandle.prev = this.end;
            instructionHandle.next = null;
            this.end = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle append(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.append(branchHandle);
        return branchHandle;
    }

    public InstructionHandle append(Instruction instruction, Instruction instruction2) {
        return this.append(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle append(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.append(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(CompoundInstruction compoundInstruction) {
        return this.append(compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.append(instructionHandle, compoundInstruction.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle instructionHandle, Instruction instruction) {
        return this.append(instructionHandle, new InstructionList(instruction));
    }

    public BranchHandle append(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.append(instructionHandle, instructionList);
        return branchHandle;
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.prev;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.prev = instructionList.end;
        instructionList.end.next = instructionHandle;
        instructionList.start.prev = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.next = instructionList.start;
        } else {
            this.start = instructionList.start;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle insert(InstructionList instructionList) {
        if (this.isEmpty()) {
            this.append(instructionList);
            return this.start;
        }
        return this.insert(this.start, instructionList);
    }

    private final void insert(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.start.prev = instructionHandle;
            instructionHandle.next = this.start;
            instructionHandle.prev = null;
            this.start = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.insert(instructionHandle, instructionList);
    }

    public InstructionHandle insert(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.insert(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle insert(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        this.insert(branchHandle);
        return branchHandle;
    }

    public InstructionHandle insert(Instruction instruction, Instruction instruction2) {
        return this.insert(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle insert(Instruction instruction, CompoundInstruction compoundInstruction) {
        return this.insert(instruction, compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(CompoundInstruction compoundInstruction) {
        return this.insert(compoundInstruction.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, Instruction instruction) {
        return this.insert(instructionHandle, new InstructionList(instruction));
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
        return this.insert(instructionHandle, compoundInstruction.getInstructionList());
    }

    public BranchHandle insert(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.insert(instructionHandle, instructionList);
        return branchHandle;
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3) {
        if (instructionHandle == null || instructionHandle2 == null) {
            throw new ClassGenException("Invalid null handle: From " + instructionHandle + " to " + instructionHandle2);
        }
        if (instructionHandle3 == instructionHandle || instructionHandle3 == instructionHandle2) {
            throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
        }
        InstructionHandle instructionHandle4 = instructionHandle;
        while (instructionHandle4 != instructionHandle2.next) {
            if (instructionHandle4 == null) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2);
            }
            if (instructionHandle4 == instructionHandle3) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
            }
            instructionHandle4 = instructionHandle4.next;
        }
        instructionHandle4 = instructionHandle.prev;
        InstructionHandle instructionHandle5 = instructionHandle2.next;
        if (instructionHandle4 != null) {
            instructionHandle4.next = instructionHandle5;
        } else {
            this.start = instructionHandle5;
        }
        if (instructionHandle5 != null) {
            instructionHandle5.prev = instructionHandle4;
        } else {
            this.end = instructionHandle4;
        }
        instructionHandle2.next = null;
        instructionHandle.prev = null;
        if (instructionHandle3 == null) {
            instructionHandle2.next = this.start;
            this.start = instructionHandle;
        } else {
            instructionHandle5 = instructionHandle3.next;
            instructionHandle3.next = instructionHandle;
            instructionHandle.prev = instructionHandle3;
            instructionHandle2.next = instructionHandle5;
            if (instructionHandle5 != null) {
                instructionHandle5.prev = instructionHandle2;
            }
        }
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        this.move(instructionHandle, instructionHandle, instructionHandle2);
    }

    private final void remove(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        Object[] objectArray;
        InstructionHandle instructionHandle3;
        if (instructionHandle == null && instructionHandle2 == null) {
            instructionHandle3 = this.start;
            objectArray = instructionHandle3;
            this.end = null;
            this.start = null;
        } else {
            if (instructionHandle == null) {
                objectArray = this.start;
                this.start = instructionHandle2;
            } else {
                objectArray = instructionHandle.next;
                instructionHandle.next = instructionHandle2;
            }
            if (instructionHandle2 == null) {
                instructionHandle3 = this.end;
                this.end = instructionHandle;
            } else {
                instructionHandle3 = instructionHandle2.prev;
                instructionHandle2.prev = instructionHandle;
            }
        }
        objectArray.prev = null;
        instructionHandle3.next = null;
        Vector<Object[]> vector = new Vector<Object[]>();
        Serializable serializable = objectArray;
        while (serializable != null) {
            ((InstructionHandle)serializable).getInstruction().dispose();
            serializable = ((InstructionHandle)serializable).next;
        }
        serializable = new StringBuffer("{ ");
        Object object = objectArray;
        while (object != null) {
            instructionHandle2 = ((InstructionHandle)object).next;
            --this.length;
            if (((InstructionHandle)object).hasTargeters()) {
                vector.addElement((Object[])object);
                ((StringBuffer)serializable).append(((InstructionHandle)object).toString(true) + " ");
                ((InstructionHandle)object).prev = null;
                ((InstructionHandle)object).next = null;
            } else {
                ((InstructionHandle)object).dispose();
            }
            object = instructionHandle2;
        }
        ((StringBuffer)serializable).append("}");
        if (!vector.isEmpty()) {
            object = new InstructionHandle[vector.size()];
            vector.copyInto((Object[])object);
            throw new TargetLostException((InstructionHandle[])object, ((StringBuffer)serializable).toString());
        }
    }

    public void delete(InstructionHandle instructionHandle) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle.next);
    }

    public void delete(Instruction instruction) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        this.delete(instructionHandle);
    }

    public void delete(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle2.next);
    }

    public void delete(Instruction instruction, Instruction instruction2) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        InstructionHandle instructionHandle2 = this.findInstruction2(instruction2);
        if (instructionHandle2 == null) {
            throw new ClassGenException("Instruction " + instruction2 + " is not contained in this list.");
        }
        this.delete(instructionHandle, instructionHandle2);
    }

    private final InstructionHandle findInstruction1(Instruction instruction) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.next;
        }
        return null;
    }

    private final InstructionHandle findInstruction2(Instruction instruction) {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.prev;
        }
        return null;
    }

    public boolean contains(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            return false;
        }
        InstructionHandle instructionHandle2 = this.start;
        while (instructionHandle2 != null) {
            if (instructionHandle2 == instructionHandle) {
                return true;
            }
            instructionHandle2 = instructionHandle2.next;
        }
        return false;
    }

    public boolean contains(Instruction instruction) {
        return this.findInstruction1(instruction) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean bl) {
        Instruction instruction;
        InstructionHandle instructionHandle;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[this.length];
        if (bl) {
            instructionHandle = this.start;
            while (instructionHandle != null) {
                instruction = instructionHandle.instruction;
                if (instruction instanceof BranchInstruction) {
                    Instruction instruction2 = ((BranchInstruction)instruction).getTarget().instruction;
                    if (!this.contains(instruction2)) {
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                    }
                    if (instruction instanceof Select) {
                        InstructionHandle[] instructionHandleArray = ((Select)instruction).getTargets();
                        int n5 = 0;
                        while (n5 < instructionHandleArray.length) {
                            instruction2 = instructionHandleArray[n5].instruction;
                            if (!this.contains(instruction2)) {
                                throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                            }
                            ++n5;
                        }
                    }
                    if (!(instructionHandle instanceof BranchHandle)) {
                        throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not contained in BranchHandle.");
                    }
                }
                instructionHandle = instructionHandle.next;
            }
        }
        instructionHandle = this.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            instructionHandle.setPosition(n3);
            nArray[n4++] = n3;
            switch (instruction.getOpcode()) {
                case 167: 
                case 168: {
                    n += 2;
                    break;
                }
                case 170: 
                case 171: {
                    n += 3;
                    break;
                }
            }
            n3 += instruction.getLength();
            instructionHandle = instructionHandle.next;
        }
        instructionHandle = this.start;
        while (instructionHandle != null) {
            n2 += instructionHandle.updatePosition(n2, n);
            instructionHandle = instructionHandle.next;
        }
        n4 = 0;
        n3 = 0;
        instructionHandle = this.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            instructionHandle.setPosition(n3);
            nArray[n4++] = n3;
            n3 += instruction.getLength();
            instructionHandle = instructionHandle.next;
        }
        this.byte_positions = new int[n4];
        System.arraycopy(nArray, 0, this.byte_positions, 0, n4);
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                Instruction instruction = instructionHandle.instruction;
                instruction.dump(dataOutputStream);
                instructionHandle = instructionHandle.next;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Instruction[] getInstructions() {
        ByteSequence byteSequence = new ByteSequence(this.getByteCode());
        Vector<Instruction> vector = new Vector<Instruction>();
        try {
            while (byteSequence.available() > 0) {
                vector.addElement(Instruction.readInstruction(byteSequence));
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        Object[] objectArray = new Instruction[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            stringBuffer.append(instructionHandle.toString(bl) + "\n");
            instructionHandle = instructionHandle.next;
        }
        return stringBuffer.toString();
    }

    public Enumeration elements() {
        return new Enumeration(this){
            private InstructionHandle ih;
            private final /* synthetic */ InstructionList this$0;

            public final Object nextElement() {
                InstructionHandle instructionHandle = this.ih;
                this.ih = this.ih.next;
                return instructionHandle;
            }

            public final boolean hasMoreElements() {
                return this.ih != null;
            }
            {
                this.this$0 = instructionList;
                this.ih = InstructionList.access$0(this.this$0);
                this.constructor$0(instructionList);
            }

            private final void constructor$0(InstructionList instructionList) {
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[this.length];
        InstructionHandle instructionHandle = this.start;
        int n = 0;
        while (n < this.length) {
            instructionHandleArray[n] = instructionHandle;
            instructionHandle = instructionHandle.next;
            ++n;
        }
        return instructionHandleArray;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public InstructionList copy() {
        Instruction instruction;
        Serializable serializable;
        Hashtable<InstructionHandle, InstructionHandle> hashtable = new Hashtable<InstructionHandle, InstructionHandle>();
        InstructionList instructionList = new InstructionList();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            serializable = instructionHandle.instruction;
            instruction = serializable.copy();
            if (instruction instanceof BranchInstruction) {
                hashtable.put(instructionHandle, instructionList.append((BranchInstruction)instruction));
            } else {
                hashtable.put(instructionHandle, instructionList.append(instruction));
            }
            instructionHandle = instructionHandle.next;
        }
        instructionHandle = this.start;
        serializable = instructionList.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            Instruction instruction2 = ((InstructionHandle)serializable).instruction;
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                BranchInstruction branchInstruction2 = (BranchInstruction)instruction2;
                InstructionHandle instructionHandle2 = branchInstruction.getTarget();
                branchInstruction2.setTarget((InstructionHandle)hashtable.get(instructionHandle2));
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    InstructionHandle[] instructionHandleArray2 = ((Select)branchInstruction2).getTargets();
                    int n = 0;
                    while (n < instructionHandleArray.length) {
                        instructionHandleArray2[n] = (InstructionHandle)hashtable.get(instructionHandleArray[n]);
                        ++n;
                    }
                }
            }
            instructionHandle = instructionHandle.next;
            serializable = ((InstructionHandle)serializable).next;
        }
        return instructionList;
    }

    public void replaceConstantPool(ConstantPoolGen constantPoolGen, ConstantPoolGen constantPoolGen2) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.instruction;
            if (instruction instanceof CPInstruction) {
                CPInstruction cPInstruction = (CPInstruction)instruction;
                Constant constant = constantPoolGen.getConstant(cPInstruction.getIndex());
                cPInstruction.setIndex(constantPoolGen2.addConstant(constant, constantPoolGen));
            }
            instructionHandle = instructionHandle.next;
        }
    }

    private final void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            instructionHandle.dispose();
            instructionHandle = instructionHandle.prev;
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        InstructionHandle instructionHandle3 = this.start;
        while (instructionHandle3 != null) {
            Instruction instruction = instructionHandle3.getInstruction();
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branchInstruction = (BranchInstruction)instruction;
                InstructionHandle instructionHandle4 = branchInstruction.getTarget();
                if (instructionHandle4 == instructionHandle) {
                    branchInstruction.setTarget(instructionHandle2);
                }
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    int n = 0;
                    while (n < instructionHandleArray.length) {
                        if (instructionHandleArray[n] == instructionHandle) {
                            ((Select)branchInstruction).setTarget(n, instructionHandle2);
                        }
                        ++n;
                    }
                }
            }
            instructionHandle3 = instructionHandle3.next;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] localVariableGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        int n = 0;
        while (n < localVariableGenArray.length) {
            InstructionHandle instructionHandle3 = localVariableGenArray[n].getStart();
            InstructionHandle instructionHandle4 = localVariableGenArray[n].getEnd();
            if (instructionHandle3 == instructionHandle) {
                localVariableGenArray[n].setStart(instructionHandle2);
            }
            if (instructionHandle4 == instructionHandle) {
                localVariableGenArray[n].setEnd(instructionHandle2);
            }
            ++n;
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] codeExceptionGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        int n = 0;
        while (n < codeExceptionGenArray.length) {
            if (codeExceptionGenArray[n].getStartPC() == instructionHandle) {
                codeExceptionGenArray[n].setStartPC(instructionHandle2);
            }
            if (codeExceptionGenArray[n].getEndPC() == instructionHandle) {
                codeExceptionGenArray[n].setEndPC(instructionHandle2);
            }
            if (codeExceptionGenArray[n].getHandlerPC() == instructionHandle) {
                codeExceptionGenArray[n].setHandlerPC(instructionHandle2);
            }
            ++n;
        }
    }

    public void addObserver(InstructionListObserver instructionListObserver) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.addElement(instructionListObserver);
    }

    public void removeObserver(InstructionListObserver instructionListObserver) {
        if (this.observers != null) {
            this.observers.removeElement(instructionListObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((InstructionListObserver)enumeration.nextElement()).notify(this);
            }
        }
    }

    static /* synthetic */ InstructionHandle access$0(InstructionList instructionList) {
        return instructionList.start;
    }

    public InstructionList() {
    }

    public InstructionList(Instruction instruction) {
        this.append(instruction);
    }

    public InstructionList(BranchInstruction branchInstruction) {
        this.append(branchInstruction);
    }

    public InstructionList(CompoundInstruction compoundInstruction) {
        this.append(compoundInstruction.getInstructionList());
    }

    public InstructionList(byte[] byArray) {
        Instruction instruction;
        int n;
        ByteSequence byteSequence = new ByteSequence(byArray);
        InstructionHandle[] instructionHandleArray = new InstructionHandle[byArray.length];
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        try {
            while (byteSequence.available() > 0) {
                nArray[n2] = n = byteSequence.getIndex();
                instruction = Instruction.readInstruction(byteSequence);
                InstructionHandle instructionHandle = instruction instanceof BranchInstruction ? this.append((BranchInstruction)instruction) : this.append(instruction);
                instructionHandle.setPosition(n);
                instructionHandleArray[n2] = instructionHandle;
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        this.byte_positions = new int[n2];
        System.arraycopy(nArray, 0, this.byte_positions, 0, n2);
        n = 0;
        while (n < n2) {
            if (instructionHandleArray[n] instanceof BranchHandle) {
                instruction = (BranchInstruction)instructionHandleArray[n].instruction;
                int n3 = ((BranchInstruction)instruction).position + ((BranchInstruction)instruction).getIndex();
                InstructionHandle instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n2, n3);
                if (instructionHandle == null) {
                    throw new ClassGenException("Couldn't find target for branch: " + instruction);
                }
                ((BranchInstruction)instruction).setTarget(instructionHandle);
                if (instruction instanceof Select) {
                    Select select = (Select)instruction;
                    int[] nArray2 = select.getIndices();
                    int n4 = 0;
                    while (n4 < nArray2.length) {
                        n3 = ((BranchInstruction)instruction).position + nArray2[n4];
                        instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n2, n3);
                        if (instructionHandle == null) {
                            throw new ClassGenException("Couldn't find target for switch: " + instruction);
                        }
                        select.setTarget(n4, instructionHandle);
                        ++n4;
                    }
                }
            }
            ++n;
        }
    }
}

