/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.ExceptionConstants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.generic.CPInstruction;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.PushInstruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower,
TypedInstruction {
    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        if (this.length == 2) {
            dataOutputStream.writeByte(this.index);
        } else {
            dataOutputStream.writeShort(this.index);
        }
    }

    public final void setIndex(int n) {
        super.setIndex(n);
        this.setSize();
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.length = (short)2;
        this.index = byteSequence.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = constantPoolGen.getConstantPool().getConstant(n);
                return ((ConstantUtf8)constant).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)constant).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC(this);
    }

    LDC() {
    }

    public LDC(int n) {
        super((short)19, n);
        this.setSize();
    }
}

