/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.generic.CPInstruction;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.PushInstruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import de.fub.bytecode.generic.Visitor;

public class LDC2_W
extends CPInstruction
implements PushInstruction,
TypedInstruction {
    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 5: {
                return Type.LONG;
            }
            case 6: {
                return Type.DOUBLE;
            }
        }
        throw new RuntimeException("Unknown constant type " + this.opcode);
    }

    public Number getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 5: {
                return new Long(((ConstantLong)constant).getBytes());
            }
            case 6: {
                return new Double(((ConstantDouble)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC2_W(this);
    }

    LDC2_W() {
    }

    public LDC2_W(int n) {
        super((short)20, n);
    }
}

