/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LOOKUPSWITCH
extends Select {
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeInt(this.match_length);
        int n = 0;
        while (n < this.match_length) {
            dataOutputStream.writeInt(this.match[n]);
            this.indices[n] = this.getTargetOffset(this.targets[n]);
            dataOutputStream.writeInt(this.indices[n]);
            ++n;
        }
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        this.match_length = byteSequence.readInt();
        this.fixed_length = (short)(9 + this.match_length * 8);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        int n = 0;
        while (n < this.match_length) {
            this.match[n] = byteSequence.readInt();
            this.indices[n] = byteSequence.readInt();
            ++n;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitLOOKUPSWITCH(this);
    }

    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)171, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(9 + this.match_length * 8);
        this.fixed_length = this.length;
    }
}

