/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionTargeter;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle ih;
    private int src_line;

    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.ih == instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (instructionHandle != this.ih) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.ih + "}");
        }
        this.setInstruction(instructionHandle2);
    }

    public LineNumber getLineNumber(ConstantPoolGen constantPoolGen) {
        return this.getLineNumber();
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public void setInstruction(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(int n) {
        this.src_line = n;
    }

    public int getSourceLine() {
        return this.src_line;
    }

    public LineNumberGen(InstructionHandle instructionHandle, int n) {
        this.setInstruction(instructionHandle);
        this.setSourceLine(n);
    }
}

