/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeExceptionGen;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.FieldGenOrMethodGen;
import de.fub.bytecode.generic.IINC;
import de.fub.bytecode.generic.IfInstruction;
import de.fub.bytecode.generic.IndexedInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.LineNumberGen;
import de.fub.bytecode.generic.LocalVariableGen;
import de.fub.bytecode.generic.LocalVariableInstruction;
import de.fub.bytecode.generic.MethodObserver;
import de.fub.bytecode.generic.NOP;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.RET;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TargetLostException;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private Vector variable_vec = new Vector();
    private Vector line_number_vec = new Vector();
    private Vector exception_vec = new Vector();
    private Vector throws_vec = new Vector();
    private Vector code_attrs_vec = new Vector();
    private Vector observers;

    public LocalVariableGen addLocalVariable(String string, Type type, int n, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        LocalVariableGen localVariableGen;
        int n2;
        byte by = type.getType();
        int n3 = type.getSize();
        if (n + n3 > this.max_locals) {
            this.max_locals = n + n3;
        }
        if ((n2 = this.variable_vec.indexOf(localVariableGen = new LocalVariableGen(n, string, type, instructionHandle, instructionHandle2))) >= 0) {
            this.variable_vec.setElementAt(localVariableGen, n2);
        } else {
            this.variable_vec.addElement(localVariableGen);
        }
        return localVariableGen;
    }

    public LocalVariableGen addLocalVariable(String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string, type, this.max_locals, instructionHandle, instructionHandle2);
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this.variable_vec.removeElement(localVariableGen);
    }

    public void removeLocalVariables() {
        this.variable_vec.removeAllElements();
    }

    private static final void sort(LocalVariableGen[] localVariableGenArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = localVariableGenArray[(n + n2) / 2].getIndex();
        while (true) {
            if (localVariableGenArray[n3].getIndex() < n5) {
                ++n3;
                continue;
            }
            while (n5 < localVariableGenArray[n4].getIndex()) {
                --n4;
            }
            if (n3 <= n4) {
                LocalVariableGen localVariableGen = localVariableGenArray[n3];
                localVariableGenArray[n3] = localVariableGenArray[n4];
                localVariableGenArray[n4] = localVariableGen;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            MethodGen.sort(localVariableGenArray, n, n4);
        }
        if (n3 < n2) {
            MethodGen.sort(localVariableGenArray, n3, n2);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int n = this.variable_vec.size();
        Object[] objectArray = new LocalVariableGen[n];
        this.variable_vec.copyInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            if (((LocalVariableGen)objectArray[n2]).getStart() == null) {
                ((LocalVariableGen)objectArray[n2]).setStart(this.il.getStart());
            }
            if (((LocalVariableGen)objectArray[n2]).getEnd() == null) {
                ((LocalVariableGen)objectArray[n2]).setEnd(this.il.getEnd());
            }
            ++n2;
        }
        if (n > 1) {
            MethodGen.sort((LocalVariableGen[])objectArray, 0, n - 1);
        }
        return objectArray;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen constantPoolGen) {
        LocalVariableGen[] localVariableGenArray = this.getLocalVariables();
        int n = localVariableGenArray.length;
        LocalVariable[] localVariableArray = new LocalVariable[n];
        int n2 = 0;
        while (n2 < n) {
            localVariableArray[n2] = localVariableGenArray[n2].getLocalVariable(constantPoolGen);
            ++n2;
        }
        return new LocalVariableTable(constantPoolGen.addUtf8("LocalVariableTable"), 2 + localVariableArray.length * 10, localVariableArray, constantPoolGen.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle instructionHandle, int n) {
        LineNumberGen lineNumberGen = new LineNumberGen(instructionHandle, n);
        this.line_number_vec.addElement(lineNumberGen);
        return lineNumberGen;
    }

    public void removeLineNumber(LineNumberGen lineNumberGen) {
        this.line_number_vec.removeElement(lineNumberGen);
    }

    public void removeLineNumbers() {
        this.line_number_vec.removeAllElements();
    }

    public LineNumberGen[] getLineNumbers() {
        Object[] objectArray = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.copyInto(objectArray);
        return objectArray;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen constantPoolGen) {
        int n = this.line_number_vec.size();
        LineNumber[] lineNumberArray = new LineNumber[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                lineNumberArray[n2] = ((LineNumberGen)this.line_number_vec.elementAt(n2)).getLineNumber();
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new LineNumberTable(constantPoolGen.addUtf8("LineNumberTable"), 2 + lineNumberArray.length * 4, lineNumberArray, constantPoolGen.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        if (instructionHandle == null || instructionHandle2 == null || instructionHandle3 == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen codeExceptionGen = new CodeExceptionGen(instructionHandle, instructionHandle2, instructionHandle3, objectType);
        this.exception_vec.addElement(codeExceptionGen);
        return codeExceptionGen;
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, String string) {
        return this.addExceptionHandler(instructionHandle, instructionHandle2, instructionHandle3, string == null ? null : new ObjectType(string));
    }

    public void removeExceptionHandler(CodeExceptionGen codeExceptionGen) {
        this.exception_vec.removeElement(codeExceptionGen);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.removeAllElements();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        Object[] objectArray = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.copyInto(objectArray);
        return objectArray;
    }

    private final CodeException[] getCodeExceptions() {
        int n = this.exception_vec.size();
        CodeException[] codeExceptionArray = new CodeException[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                CodeExceptionGen codeExceptionGen = (CodeExceptionGen)this.exception_vec.elementAt(n2);
                codeExceptionArray[n2] = codeExceptionGen.getCodeException(this.cp);
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return codeExceptionArray;
    }

    public void addException(String string) {
        this.throws_vec.addElement(string);
    }

    public void removeException(String string) {
        this.throws_vec.removeElement(string);
    }

    public void removeExceptions() {
        this.throws_vec.removeAllElements();
    }

    public String[] getExceptions() {
        Object[] objectArray = new String[this.throws_vec.size()];
        this.throws_vec.copyInto(objectArray);
        return objectArray;
    }

    private final ExceptionTable getExceptionTable(ConstantPoolGen constantPoolGen) {
        int n = this.throws_vec.size();
        int[] nArray = new int[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = constantPoolGen.addClass((String)this.throws_vec.elementAt(n2));
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(constantPoolGen.addUtf8("Exceptions"), 2 + 2 * n, nArray, constantPoolGen.getConstantPool());
    }

    public void addCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.addElement(attribute);
    }

    public void removeCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.removeElement(attribute);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.removeAllElements();
    }

    public Attribute[] getCodeAttributes() {
        Object[] objectArray = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.copyInto(objectArray);
        return objectArray;
    }

    public Method getMethod() {
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        byte[] byArray = null;
        if (this.il != null) {
            byArray = this.il.getByteCode();
        }
        LineNumberTable lineNumberTable = null;
        LocalVariableTable localVariableTable = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            localVariableTable = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(localVariableTable);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lineNumberTable = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lineNumberTable);
        }
        Attribute[] attributeArray = this.getCodeAttributes();
        int n3 = 0;
        int n4 = 0;
        while (n4 < attributeArray.length) {
            n3 += attributeArray[n4].getLength() + 6;
            ++n4;
        }
        CodeException[] codeExceptionArray = this.getCodeExceptions();
        int n5 = codeExceptionArray.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            code = new Code(this.cp.addUtf8("Code"), 8 + byArray.length + 2 + n5 + 2 + n3, this.max_stack, this.max_locals, byArray, codeExceptionArray, attributeArray, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        ExceptionTable exceptionTable = null;
        if (this.throws_vec.size() > 0) {
            exceptionTable = this.getExceptionTable(this.cp);
            this.addAttribute(exceptionTable);
        }
        Method method = new Method(this.access_flags, n, n2, this.getAttributes(), this.cp.getConstantPool());
        if (localVariableTable != null) {
            this.removeCodeAttribute(localVariableTable);
        }
        if (lineNumberTable != null) {
            this.removeCodeAttribute(lineNumberTable);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (exceptionTable != null) {
            this.removeAttribute(exceptionTable);
        }
        return method;
    }

    /*
     * Unable to fully structure code
     */
    public void removeNOPs() {
        if (this.il != null) {
            var2_1 = this.il.getStart();
            while (var2_1 != null) {
                block7: {
                    var1_2 = var2_1.next;
                    if (var1_2 != null && var2_1.getInstruction() instanceof NOP) {
                        try {
                            this.il.delete(var2_1);
                            break block7;
                        }
                        catch (TargetLostException var3_3) {
                            var4_4 = var3_3.getTargets();
                            var5_5 = 0;
                            ** while (var5_5 < var4_4.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var6_6 = var4_4[var5_5].getTargeters();
                            var7_7 = 0;
                            while (var7_7 < var6_6.length) {
                                var6_6[var7_7].updateTarget(var4_4[var5_5], var1_2);
                                ++var7_7;
                            }
                            ++var5_5;
                            continue;
                        }
                    }
                }
                var2_1 = var1_2;
            }
        }
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public void setMethodName(String string) {
        this.setName(string);
    }

    public String getMethodName() {
        return this.getName();
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setReturnType(Type type) {
        this.setType(type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] typeArray) {
        this.arg_types = typeArray;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int n, Type type) {
        this.arg_types[n] = type;
    }

    public Type getArgumentType(int n) {
        return this.arg_types[n];
    }

    public void setArgumentNames(String[] stringArray) {
        this.arg_names = stringArray;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int n, String string) {
        this.arg_names[n] = string;
    }

    public String getArgumentName(int n) {
        return this.arg_names[n];
    }

    public void setArgTypes(Type[] typeArray) {
        this.arg_types = typeArray;
    }

    public Type[] getArgTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgType(int n, Type type) {
        this.arg_types[n] = type;
    }

    public Type getArgType(int n) {
        return this.arg_types[n];
    }

    public void setArgNames(String[] stringArray) {
        this.arg_names = stringArray;
    }

    public String[] getArgNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgName(int n, String string) {
        this.arg_names[n] = string;
    }

    public String getArgName(int n) {
        return this.arg_names[n];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
    }

    public String getMethodSignature() {
        return this.getSignature();
    }

    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int n;
            int n2 = n = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                int n3 = 0;
                while (n3 < this.arg_types.length) {
                    n += this.arg_types[n3].getSize();
                    ++n3;
                }
            }
            InstructionHandle instructionHandle = this.il.getStart();
            while (instructionHandle != null) {
                int n4;
                Instruction instruction = instructionHandle.getInstruction();
                if ((instruction instanceof LocalVariableInstruction || instruction instanceof RET || instruction instanceof IINC) && (n4 = ((IndexedInstruction)((Object)instruction)).getIndex() + ((TypedInstruction)((Object)instruction)).getType(this.cp).getSize()) > n) {
                    n = n4;
                }
                instructionHandle = instructionHandle.getNext();
            }
            this.max_locals = n;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean bl) {
        this.strip_attributes = bl;
    }

    public static int getMaxStack(ConstantPoolGen constantPoolGen, InstructionList instructionList, CodeExceptionGen[] codeExceptionGenArray) {
        BranchStack branchStack = new BranchStack();
        int n = 0;
        while (n < codeExceptionGenArray.length) {
            InstructionHandle instructionHandle = codeExceptionGenArray[n].getHandlerPC();
            if (instructionHandle != null) {
                branchStack.push(instructionHandle, 1);
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        InstructionHandle instructionHandle = instructionList.getStart();
        while (instructionHandle != null) {
            Object object;
            Instruction instruction = instructionHandle.getInstruction();
            short s = instruction.getOpcode();
            int n3 = instruction.produceStack(constantPoolGen) - instruction.consumeStack(constantPoolGen);
            if ((n += n3) > n2) {
                n2 = n;
            }
            if (instruction instanceof BranchInstruction) {
                object = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    Select select = (Select)object;
                    InstructionHandle[] instructionHandleArray = select.getTargets();
                    int n4 = 0;
                    while (n4 < instructionHandleArray.length) {
                        branchStack.push(instructionHandleArray[n4], n);
                        ++n4;
                    }
                    instructionHandle = null;
                } else if (!(object instanceof IfInstruction)) {
                    if (s == 168 || s == 201) {
                        branchStack.push(instructionHandle.getNext(), n - 1);
                    }
                    instructionHandle = null;
                }
                branchStack.push(((BranchInstruction)object).getTarget(), n);
            } else if (s == 191 || s == 169 || s >= 172 && s <= 177) {
                instructionHandle = null;
            }
            if (instructionHandle != null) {
                instructionHandle = instructionHandle.getNext();
            }
            if (instructionHandle != null || (object = branchStack.pop()) == null) continue;
            instructionHandle = ((BranchTarget)object).target;
            n = ((BranchTarget)object).stackDepth;
        }
        return n2;
    }

    public void addObserver(MethodObserver methodObserver) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.addElement(methodObserver);
    }

    public void removeObserver(MethodObserver methodObserver) {
        if (this.observers != null) {
            this.observers.removeElement(methodObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((MethodObserver)enumeration.nextElement()).notify(this);
            }
        }
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        String string2 = Type.getMethodSignature(this.type, this.arg_types);
        string2 = Utility.methodSignatureToString(string2, this.name, string, true, this.getLocalVariableTable(this.cp));
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (this.throws_vec.size() > 0) {
            Enumeration enumeration = this.throws_vec.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("\n\t\tthrows " + enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    public MethodGen copy(String string, ConstantPoolGen constantPoolGen) {
        Method method = ((MethodGen)this.clone()).getMethod();
        MethodGen methodGen = new MethodGen(method, string, this.cp);
        if (this.cp != constantPoolGen) {
            methodGen.setConstantPool(constantPoolGen);
            methodGen.getInstructionList().replaceConstantPool(this.cp, constantPoolGen);
        }
        return methodGen;
    }

    public MethodGen(int n, Type type, Type[] typeArray, String[] stringArray, String string, String string2, InstructionList instructionList, ConstantPoolGen constantPoolGen) {
        this.setAccessFlags(n);
        this.setType(type);
        this.setArgumentTypes(typeArray);
        this.setArgumentNames(stringArray);
        this.setName(string);
        this.setClassName(string2);
        this.setInstructionList(instructionList);
        this.setConstantPool(constantPoolGen);
        if ((n & 0x500) == 0) {
            InstructionHandle instructionHandle = instructionList.getStart();
            InstructionHandle instructionHandle2 = instructionList.getEnd();
            if (!this.isStatic() && string2 != null) {
                this.addLocalVariable("this", new ObjectType(string2), instructionHandle, instructionHandle2);
            }
            if (typeArray != null) {
                int n2;
                int n3 = typeArray.length;
                if (stringArray != null) {
                    if (n3 != stringArray.length) {
                        throw new ClassGenException("Mismatch in argument array lengths: " + n3 + " vs. " + stringArray.length);
                    }
                } else {
                    stringArray = new String[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        stringArray[n2] = "arg" + n2;
                        ++n2;
                    }
                    this.setArgumentNames(stringArray);
                }
                n2 = 0;
                while (n2 < n3) {
                    this.addLocalVariable(stringArray[n2], typeArray[n2], instructionHandle, instructionHandle2);
                    ++n2;
                }
            }
        }
    }

    public MethodGen(Method method, String string, ConstantPoolGen constantPoolGen) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), string, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(method.getCode().getCode()) : null, constantPoolGen);
        Attribute[] attributeArray = method.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            String[] stringArray;
            Attribute attribute = attributeArray[n];
            if (attribute instanceof Code) {
                InstructionHandle instructionHandle;
                stringArray = (String[])attribute;
                this.setMaxStack(stringArray.getMaxStack());
                this.setMaxLocals(stringArray.getMaxLocals());
                CodeException[] codeExceptionArray = stringArray.getExceptionTable();
                if (codeExceptionArray != null) {
                    int n2 = 0;
                    while (n2 < codeExceptionArray.length) {
                        CodeException codeException = codeExceptionArray[n2];
                        int n3 = codeException.getCatchType();
                        ObjectType objectType = null;
                        if (n3 > 0) {
                            String string2 = method.getConstantPool().getConstantString(n3, (byte)7);
                            objectType = new ObjectType(string2);
                        }
                        int n4 = codeException.getEndPC();
                        int n5 = method.getCode().getCode().length;
                        if (n5 == n4) {
                            instructionHandle = this.il.getEnd();
                        } else {
                            instructionHandle = this.il.findHandle(n4);
                            instructionHandle = instructionHandle.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(codeException.getStartPC()), instructionHandle, this.il.findHandle(codeException.getHandlerPC()), objectType);
                        ++n2;
                    }
                }
                Attribute[] attributeArray2 = stringArray.getAttributes();
                int n6 = 0;
                while (n6 < attributeArray2.length) {
                    attribute = attributeArray2[n6];
                    if (attribute instanceof LineNumberTable) {
                        LineNumber[] lineNumberArray = ((LineNumberTable)attribute).getLineNumberTable();
                        int n7 = 0;
                        while (n7 < lineNumberArray.length) {
                            LineNumber lineNumber = lineNumberArray[n7];
                            this.addLineNumber(this.il.findHandle(lineNumber.getStartPC()), lineNumber.getLineNumber());
                            ++n7;
                        }
                    } else if (attribute instanceof LocalVariableTable) {
                        LocalVariable[] localVariableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                        int n8 = 0;
                        while (n8 < localVariableArray.length) {
                            LocalVariable localVariable = localVariableArray[n8];
                            InstructionHandle instructionHandle2 = this.il.findHandle(localVariable.getStartPC());
                            instructionHandle = this.il.findHandle(localVariable.getStartPC() + localVariable.getLength());
                            if (instructionHandle2 == null) {
                                instructionHandle2 = this.il.getStart();
                            }
                            if (instructionHandle == null) {
                                instructionHandle = this.il.getEnd();
                            }
                            this.addLocalVariable(localVariable.getName(), Type.getType(localVariable.getSignature()), localVariable.getIndex(), instructionHandle2, instructionHandle);
                            ++n8;
                        }
                    } else {
                        this.addCodeAttribute(attribute);
                    }
                    ++n6;
                }
            } else if (attribute instanceof ExceptionTable) {
                stringArray = ((ExceptionTable)attribute).getExceptionNames();
                int n9 = 0;
                while (n9 < stringArray.length) {
                    this.addException(stringArray[n9]);
                    ++n9;
                }
            } else {
                this.addAttribute(attribute);
            }
            ++n;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle instructionHandle, int n) {
            this.target = instructionHandle;
            this.stackDepth = n;
        }
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        public final void push(InstructionHandle instructionHandle, int n) {
            if (this.visited(instructionHandle)) {
                return;
            }
            this.branchTargets.push(this.visit(instructionHandle, n));
        }

        public final BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget branchTarget = (BranchTarget)this.branchTargets.pop();
                return branchTarget;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle instructionHandle, int n) {
            BranchTarget branchTarget = new BranchTarget(instructionHandle, n);
            this.visitedTargets.put(instructionHandle, branchTarget);
            return branchTarget;
        }

        private final boolean visited(InstructionHandle instructionHandle) {
            return this.visitedTargets.get(instructionHandle) != null;
        }

        BranchStack() {
        }
    }
}

