/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.ExceptionConstants;
import de.fub.bytecode.generic.AllocationInstruction;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.StackProducer;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + Constants.TYPE_NAMES[this.type];
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.type = byteSequence.readByte();
        this.length = (short)2;
    }

    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    public void accept(Visitor visitor) {
        visitor.visitAllocationInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitStackProducer(this);
        visitor.visitNEWARRAY(this);
    }

    NEWARRAY() {
    }

    public NEWARRAY(byte by) {
        super((short)188, (short)2);
        this.type = by;
    }

    public NEWARRAY(BasicType basicType) {
        this(basicType.getType());
    }
}

