/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.StackProducer;
import de.fub.bytecode.generic.VariableLengthInstruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackProducer {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    protected int updatePosition(int n, int n2) {
        this.position += n;
        short s = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        int n = 0;
        while (n < this.padding) {
            dataOutputStream.writeByte(0);
            ++n;
        }
        this.index = this.getTargetOffset();
        dataOutputStream.writeInt(this.index);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        int n = 0;
        while (n < this.padding) {
            byte by = byteSequence.readByte();
            if (by != 0) {
                throw new ClassGenException("Padding byte != 0: " + by);
            }
            ++n;
        }
        this.index = byteSequence.readInt();
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(bl));
        if (bl) {
            int n = 0;
            while (n < this.match_length) {
                String string = "null";
                if (this.targets[n] != null) {
                    string = this.targets[n].getInstruction().toString();
                }
                stringBuffer.append("(" + this.match[n] + ", " + string + " = {" + this.indices[n] + "})");
                ++n;
            }
        } else {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    public void setTarget(int n, InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.targets[n], instructionHandle, this);
        this.targets[n] = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.target == instructionHandle) {
            bl = true;
            this.setTarget(instructionHandle2);
        }
        int n = 0;
        while (n < this.targets.length) {
            if (this.targets[n] == instructionHandle) {
                bl = true;
                this.setTarget(n, instructionHandle2);
            }
            ++n;
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (this.target == instructionHandle) {
            return true;
        }
        int n = 0;
        while (n < this.targets.length) {
            if (this.targets[n] == instructionHandle) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void dispose() {
        super.dispose();
        int n = 0;
        while (n < this.targets.length) {
            this.targets[n].removeTargeter(this);
            ++n;
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    Select() {
    }

    Select(short s, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s, instructionHandle);
        this.targets = instructionHandleArray;
        int n = 0;
        while (n < instructionHandleArray.length) {
            BranchInstruction.notifyTarget(null, instructionHandleArray[n], this);
            ++n;
        }
        this.match = nArray;
        this.match_length = nArray.length;
        if (this.match_length != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }
}

