/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n = this.match_length > 0 ? this.match[0] : 0;
        dataOutputStream.writeInt(n);
        int n2 = this.match_length > 0 ? this.match[this.match_length - 1] : 0;
        dataOutputStream.writeInt(n2);
        int n3 = 0;
        while (n3 < this.match_length) {
            this.indices[n3] = this.getTargetOffset(this.targets[n3]);
            dataOutputStream.writeInt(this.indices[n3]);
            ++n3;
        }
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        int n = byteSequence.readInt();
        int n2 = byteSequence.readInt();
        this.match_length = n2 - n + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        int n3 = n;
        while (n3 <= n2) {
            this.match[n3 - n] = n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.match_length) {
            this.indices[n3] = byteSequence.readInt();
            ++n3;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitTABLESWITCH(this);
    }

    TABLESWITCH() {
    }

    public TABLESWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)170, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }
}

