/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.ReferenceType;
import de.fub.bytecode.generic.Type;
import java.util.Vector;

public abstract class Type {
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType();
    public static final Type UNKNOWN = new 1(15, "<unknown object>");
    private static int consumed_chars = 0;
    protected byte type;
    protected String signature;

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = typeArray == null ? 0 : typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(typeArray[n2].getSignature());
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer.append(type.getSignature());
        return stringBuffer.toString();
    }

    public static final Type getType(String string) throws StringIndexOutOfBoundsException {
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            consumed_chars = 1;
            return BasicType.getType(by);
        }
        if (by == 13) {
            int n = 0;
            while (string.charAt(++n) == '[') {
            }
            Type type = Type.getType(string.substring(n));
            consumed_chars += n;
            return new ArrayType(type, n);
        }
        int n = string.indexOf(59);
        if (n < 0) {
            throw new ClassFormatError("Invalid signature: " + string);
        }
        consumed_chars = n + 1;
        return new ObjectType(string.substring(1, n).replace('/', '.'));
    }

    public static Type getReturnType(String string) {
        try {
            int n = string.lastIndexOf(41) + 1;
            return Type.getType(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
    }

    public static Type[] getArgumentTypes(String string) {
        Vector<Type> vector = new Vector<Type>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                vector.addElement(Type.getType(string.substring(n)));
                n += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        Object[] objectArray = new Type[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Type(byte by, String string) {
        this.type = by;
        this.signature = string;
    }
}

