/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.util;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantCP;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.util.ByteSequence;
import de.fub.bytecode.util.Class2HTML;
import de.fub.bytecode.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML
implements Constants {
    private static boolean wide = false;
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;

    private final String codeToHTML(ByteSequence byteSequence, int n) throws IOException {
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer("<TT>" + Constants.OPCODE_NAMES[s] + "</TT></TD><TD>");
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            n2 = 0;
            while (n2 < n5) {
                byteSequence.readByte();
                ++n2;
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                n4 += n8;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n7 - n6 + 1];
                n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + (n6 + n3) + "</TH>");
                    ++n3;
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                n3 = 0;
                while (n3 < nArray.length) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + nArray[n3] + "\">" + nArray[n3] + "</A></TD>");
                    ++n3;
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + n4 + "\">" + n4 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                n3 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n3];
                n4 += n9;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                n2 = 0;
                while (n2 < n3) {
                    int n10 = byteSequence.readInt();
                    nArray[n2] = n9 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + n10 + "</TH>");
                    ++n2;
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                n2 = 0;
                while (n2 < n3) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + nArray[n2] + "\">" + nArray[n2] + "</A></TD>");
                    ++n2;
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n + "@" + n4 + "\">" + n4 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n11 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuffer.append("<A HREF=\"#code" + n + "@" + n11 + "\">" + n11 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                n2 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuffer.append("<A HREF=\"#code" + n + "@" + n2 + "\">" + n2 + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n12;
                if (wide) {
                    n12 = byteSequence.readShort();
                    wide = false;
                } else {
                    n12 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("%" + n12);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("<FONT COLOR=\"#00FF00\">" + Constants.TYPE_NAMES[byteSequence.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n13 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n13, (byte)9);
                int n14 = constantFieldref.getClassIndex();
                String string = this.constant_pool.getConstantString(n14, (byte)7);
                string = Utility.compactClassName(string, false);
                n13 = constantFieldref.getNameAndTypeIndex();
                String string2 = this.constant_pool.constantToString(n13, (byte)12);
                if (string.equals(this.class_name)) {
                    stringBuffer.append("<A HREF=\"" + this.class_name + "_methods.html#field" + string2 + "\" TARGET=Methods>" + string2 + "</A>\n");
                    break;
                }
                stringBuffer.append(this.constant_html.referenceConstant(n14) + "." + string2);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s2 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s2));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n15;
                String string;
                int n16;
                Object object;
                short s3 = byteSequence.readShort();
                if (s == 185) {
                    int n17 = byteSequence.readUnsignedByte();
                    int n18 = byteSequence.readUnsignedByte();
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s3, (byte)11);
                    n16 = ((ConstantCP)object).getClassIndex();
                    string = this.constant_pool.constantToString((Constant)object);
                    n15 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    ConstantMethodref constantMethodref = (ConstantMethodref)this.constant_pool.getConstant(s3, (byte)10);
                    n16 = constantMethodref.getClassIndex();
                    string = this.constant_pool.constantToString(constantMethodref);
                    n15 = constantMethodref.getNameAndTypeIndex();
                }
                String string3 = Class2HTML.referenceClass(n16);
                string = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n15, (byte)12)));
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n15, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                object = Utility.methodSignatureReturnType(string4, false);
                stringBuffer.append(string3 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + s3 + "\" TARGET=ConstantPool>" + string + "</A>" + "(");
                int n19 = 0;
                while (n19 < stringArray.length) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[n19]));
                    if (n19 < stringArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n19;
                }
                stringBuffer.append("):" + Class2HTML.referenceType((String)object));
                break;
            }
            case 19: 
            case 20: {
                short s4 = byteSequence.readShort();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + s4 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(s4, this.constant_pool.getConstant(s4).getTag())) + "</a>");
                break;
            }
            case 18: {
                int n20 = byteSequence.readUnsignedByte();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + n20 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(n20, this.constant_pool.getConstant(n20).getTag())) + "</a>");
                break;
            }
            case 189: {
                short s5 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s5));
                break;
            }
            case 197: {
                short s6 = byteSequence.readShort();
                byte by = byteSequence.readByte();
                stringBuffer.append(this.constant_html.referenceConstant(s6) + ":" + by + "-dimensional");
                break;
            }
            case 132: {
                short s7;
                int n21;
                if (wide) {
                    n21 = byteSequence.readShort();
                    s7 = byteSequence.readShort();
                    wide = false;
                } else {
                    n21 = byteSequence.readUnsignedByte();
                    s7 = byteSequence.readByte();
                }
                stringBuffer.append("%" + n21 + " " + s7);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s] <= 0) break;
                int n22 = 0;
                while (n22 < Constants.TYPE_OF_OPERANDS[s].length) {
                    switch (Constants.TYPE_OF_OPERANDS[s][n22]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    stringBuffer.append("&nbsp;");
                    ++n22;
                }
                break block0;
            }
        }
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    private final void findGotos(ByteSequence byteSequence, Method method, Code code) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            n5 = codeExceptionArray.length;
            int n6 = 0;
            while (n6 < n5) {
                this.goto_set.set(codeExceptionArray[n6].getStartPC());
                this.goto_set.set(codeExceptionArray[n6].getEndPC());
                this.goto_set.set(codeExceptionArray[n6].getHandlerPC());
                ++n6;
            }
            Attribute[] attributeArray = code.getAttributes();
            n4 = 0;
            while (n4 < attributeArray.length) {
                if (attributeArray[n4].getTag() == 5) {
                    LocalVariable[] localVariableArray = ((LocalVariableTable)attributeArray[n4]).getLocalVariableTable();
                    n3 = 0;
                    while (n3 < localVariableArray.length) {
                        n2 = localVariableArray[n3].getStartPC();
                        n = n2 + localVariableArray[n3].getLength();
                        this.goto_set.set(n2);
                        this.goto_set.set(n);
                        ++n3;
                    }
                    break;
                }
                ++n4;
            }
        }
        int n7 = 0;
        while (byteSequence.available() > 0) {
            int n8 = byteSequence.readUnsignedByte();
            switch (n8) {
                case 170: 
                case 171: {
                    int n9;
                    int n10;
                    n5 = byteSequence.getIndex() % 4;
                    int n11 = n5 == 0 ? 0 : 4 - n5;
                    n3 = 0;
                    while (n3 < n11) {
                        byteSequence.readByte();
                        ++n3;
                    }
                    n4 = byteSequence.readInt();
                    if (n8 == 170) {
                        n3 = byteSequence.readInt();
                        n2 = byteSequence.readInt();
                        n10 = byteSequence.getIndex() - 12 - n11 - 1;
                        this.goto_set.set(n4 += n10);
                        n = 0;
                        while (n < n2 - n3 + 1) {
                            n9 = n10 + byteSequence.readInt();
                            this.goto_set.set(n9);
                            ++n;
                        }
                    } else {
                        n3 = byteSequence.readInt();
                        n10 = byteSequence.getIndex() - 8 - n11 - 1;
                        this.goto_set.set(n4 += n10);
                        n2 = 0;
                        while (n2 < n3) {
                            n = byteSequence.readInt();
                            n9 = n10 + byteSequence.readInt();
                            this.goto_set.set(n9);
                            ++n2;
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n9 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                case 200: 
                case 201: {
                    int n9 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n9);
                    break;
                }
                default: {
                    byteSequence.unreadByte();
                    this.codeToHTML(byteSequence, 0);
                }
            }
            ++n7;
        }
    }

    private final void writeMethod(Method method, int n) throws IOException {
        int n2;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Class2HTML.toHTML(string3);
        String string5 = Utility.accessToString(method.getAccessFlags());
        string5 = Utility.replace(string5, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string5 + "</FONT>&nbsp;" + "<A NAME=method" + n + ">" + Class2HTML.referenceType(string2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n + "\" TARGET=Methods>" + string4 + "</A>(");
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.file.print(Class2HTML.referenceType(stringArray[n3]));
            if (n3 < stringArray.length - 1) {
                this.file.print(",&nbsp;");
            }
            ++n3;
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            int n4 = 0;
            while (n4 < attributeArray.length) {
                n2 = attributeArray[n4].getTag();
                if (n2 != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n + "@" + n4 + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[n2] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[n4] + "</LI>");
                }
                if (n2 == 2) {
                    code = (Code)attributeArray[n4];
                    Attribute[] attributeArray2 = code.getAttributes();
                    byArray = code.getCode();
                    this.file.print("<UL>");
                    int n5 = 0;
                    while (n5 < attributeArray2.length) {
                        n2 = attributeArray2[n5].getTag();
                        this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + n + "@" + n4 + "@" + n5 + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[n2] + "</A></LI>\n");
                        ++n5;
                    }
                    this.file.print("</UL>");
                }
                ++n4;
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            ByteSequence byteSequence = new ByteSequence(byArray);
            byteSequence.mark(byteSequence.available());
            this.findGotos(byteSequence, method, code);
            byteSequence.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            n2 = 0;
            while (byteSequence.available() > 0) {
                int n6 = byteSequence.getIndex();
                String string6 = this.codeToHTML(byteSequence, n);
                String string7 = "";
                if (this.goto_set.get(n6)) {
                    string7 = "<A NAME=code" + n + "@" + n6 + "></A>";
                }
                String string8 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n + "@" + byArray.length + ">" + n6 + "</A>" : "" + n6;
                this.file.println("<TR VALIGN=TOP><TD>" + string8 + "</TD><TD>" + string7 + string6 + "</TR>");
                ++n2;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }

    CodeHTML(String string, String string2, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.methods = methodArray;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        int n = 0;
        while (n < methodArray.length) {
            this.writeMethod(methodArray[n], n);
            ++n;
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }
}

