/*
 * Decompiled with CFR 0.152.
 */
package com.chatley.magicbeans;

import com.chatley.magicbeans.Component;
import com.chatley.magicbeans.PluginManager;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import net.iharder.dnd.FileDrop;
import syntaxHighlight.DarwinTextArea;

public class Builder
extends JFrame {
    private DarwinTextArea o_editor;
    private DarwinTextArea o_fsp_pane;
    private JToolBar o_toolbar;
    private FileDrop o_filedrop;
    private JButton o_gen;
    private Component o_comp;

    public Builder() {
        super("Plugin Builder");
        this.getContentPane().setLayout(new BorderLayout());
        this.o_gen = new GeneratorButton();
        this.resetToolbar();
        this.o_editor = new DarwinTextArea();
        this.o_fsp_pane = new DarwinTextArea();
        this.o_filedrop = new FileDrop((java.awt.Component)this.o_editor, new FileDrop.Listener(){

            public void filesDropped(File[] fileArray) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].getName().endsWith(".jar")) {
                        Builder.this.o_comp = new Component(fileArray[n].getPath(), this.getClass().getClassLoader());
                        PluginManager.DarwinGenerator darwinGenerator = PluginManager.getInstance().getDarwinGenerator(false);
                        String string = darwinGenerator.analyseComponent(Builder.this.o_comp);
                        Builder.this.o_editor.setText(string);
                        Builder.this.resetToolbar();
                        Set set = darwinGenerator.getAllActions(Builder.this.o_comp);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Builder.this.o_toolbar.add(new ActionButton((String)iterator.next()));
                        }
                        Builder.this.getContentPane().add((java.awt.Component)Builder.this.o_toolbar, "North");
                        String string2 = darwinGenerator.getBehaviour(Builder.this.o_comp);
                        if (string2.trim().equals("")) {
                            Builder.this.o_fsp_pane.setText(darwinGenerator.getProcessName(Builder.this.o_comp) + " = ");
                        } else {
                            Builder.this.o_fsp_pane.setText(string2);
                        }
                        Builder.this.pack();
                    } else if (fileArray[n].getName().endsWith(".class")) {
                        // empty if block
                    }
                    ++n;
                }
            }
        });
        this.getContentPane().add((java.awt.Component)new JSplitPane(0, (java.awt.Component)this.o_editor, (java.awt.Component)this.o_fsp_pane), "Center");
        this.pack();
        this.show();
    }

    private void resetToolbar() {
        this.o_toolbar = new JToolBar();
        this.o_toolbar.add(this.o_gen);
        this.o_toolbar.addSeparator();
    }

    private String lastPart(String string) {
        String string2 = string.trim();
        if (string2.endsWith(".jar")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if (string2.indexOf(".") > -1) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1, string2.length());
        }
        if (string2.indexOf("\\") > -1) {
            string2 = string2.substring(string2.lastIndexOf("\\") + 1, string2.length());
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        new Builder();
    }

    class GeneratorButton
    extends JButton {
        GeneratorButton() {
            super("Generate");
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneratorButton this$1;
                {
                    this.this$1 = generatorButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        File file = new File("Behaviour.java");
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        printWriter.println("class Behaviour implements com.chatley.magicbeans.FSPSpecification {\n\n\tpublic String getFSP() {\n\n\t\treturn \"" + Builder.access$400(GeneratorButton.access$600(this.this$1)).getText().trim() + "\";\n\t}\n" + "}\n");
                        printWriter.flush();
                        printWriter.close();
                        if (Compiler.compileClasses((String)file.getPath())) {
                            System.out.println("compiled ok");
                        } else {
                            System.out.println("didn't compile");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        static /* synthetic */ Builder access$600(GeneratorButton generatorButton) {
            return generatorButton.Builder.this;
        }
    }

    class ActionButton
    extends JButton {
        String o_name;

        ActionButton(String string) {
            super(string);
            this.o_name = string;
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ ActionButton this$1;
                {
                    this.this$1 = actionButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Builder.access$400(ActionButton.access$500(this.this$1)).setText(Builder.access$400(ActionButton.access$500(this.this$1)).getText() + this.this$1.o_name);
                }
            });
        }

        static /* synthetic */ Builder access$500(ActionButton actionButton) {
            return actionButton.Builder.this;
        }
    }
}

