/*
 * Decompiled with CFR 0.152.
 */
package com.chatley.magicbeans;

import com.chatley.magicbeans.Component;
import de.fub.bytecode.Repository;
import de.fub.bytecode.classfile.ClassParser;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.generic.MethodGen;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class ByteCodeChecker {
    boolean code = true;
    boolean constants = false;
    boolean verbose = false;
    boolean classdep = false;
    boolean nocontents = false;
    boolean recurse = false;
    Hashtable listedClasses = new Hashtable();
    Vector exclude_name = new Vector();
    Set o_fields = new HashSet();
    String o_name;

    public ByteCodeChecker() {
    }

    public ByteCodeChecker(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Vector vector) {
        this.code = bl;
        this.constants = bl2;
        this.verbose = bl3;
        this.classdep = bl4;
        this.nocontents = bl5;
        this.recurse = bl6;
        this.listedClasses = new Hashtable();
        this.exclude_name = vector;
        this.o_fields = new HashSet();
    }

    public void list(String string) {
        try {
            this.o_name = string;
            if (this.listedClasses.get(string) != null || string.startsWith("[")) {
                return;
            }
            int n = 0;
            while (n < this.exclude_name.size()) {
                if (string.startsWith((String)this.exclude_name.elementAt(n))) {
                    return;
                }
                ++n;
            }
            JavaClass javaClass = Repository.lookupClass(string);
            if (javaClass == null) {
                javaClass = new ClassParser(string).parse();
            }
            Field[] fieldArray = javaClass.getFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                this.o_fields.add(fieldArray[n2].getName());
                ++n2;
            }
            this.printCode(javaClass.getMethods(), this.verbose);
        }
        catch (IOException iOException) {
            System.out.println("Error loading class " + string + " (" + iOException.getMessage() + ")");
        }
        catch (Exception exception) {
            System.out.println("Error processing class " + string + " (" + exception.getMessage() + ")");
        }
    }

    public String getByteCode(Component component, String string) {
        try {
            Object object;
            this.o_name = string;
            if (this.listedClasses.get(string) != null || string.startsWith("[")) {
                return "";
            }
            int n = 0;
            while (n < this.exclude_name.size()) {
                if (string.startsWith((String)this.exclude_name.elementAt(n))) {
                    return "";
                }
                ++n;
            }
            JavaClass javaClass = Repository.lookupClass(string);
            if (javaClass == null) {
                object = string.replaceAll("\\.", "/") + ".class";
                InputStream inputStream = component.getResourceAsStream((String)object);
                javaClass = new ClassParser(inputStream, string).parse();
            }
            object = javaClass.getFields();
            int n2 = 0;
            while (n2 < ((Field[])object).length) {
                this.o_fields.add(object[n2].getName());
                ++n2;
            }
            return this.printCode(javaClass.getMethods(), this.verbose);
        }
        catch (IOException iOException) {
            System.out.println("Error loading class " + string + " (" + iOException.getMessage() + ")");
        }
        catch (Exception exception) {
            System.out.println("Error processing class " + string + " (" + exception.getMessage() + ")");
            exception.printStackTrace();
        }
        return "";
    }

    public static void printClassDependencies(ConstantPool constantPool) {
        String[] stringArray = ByteCodeChecker.getClassDependencies(constantPool);
        System.out.println("Dependencies:");
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("\t" + stringArray[n]);
            ++n;
        }
    }

    public static String[] getClassDependencies(ConstantPool constantPool) {
        Object object;
        String[] stringArray = new String[constantPool.getLength()];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < constantPool.getLength()) {
            object = constantPool.getConstant(n2);
            if (object != null && ((Constant)object).getTag() == 7) {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(((ConstantClass)object).getNameIndex());
                stringBuffer.setLength(0);
                stringBuffer.append(new String(constantUtf8.getBytes()));
                int n3 = 0;
                while (n3 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n3) == '/') {
                        stringBuffer.setCharAt(n3, '.');
                    }
                    ++n3;
                }
                stringArray[n++] = stringBuffer.toString();
            }
            ++n2;
        }
        object = new String[n];
        System.arraycopy(stringArray, 0, object, 0, n);
        return object;
    }

    public String printCode(Method[] methodArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals("pluginAdded")) {
                String string = new MethodGen(methodArray[n], this.o_name, null).getArgumentType(0).toString();
                Code code = methodArray[n].getCode();
                if (code != null) {
                    String string2 = code.toString(bl);
                    stringBuffer = stringBuffer.append(string2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean inByteCode(Component component, String string, String string2) {
        String string3 = this.getByteCode(component, string);
        return string3.indexOf(string2) > -1;
    }

    public static void main(String[] stringArray) {
        new ByteCodeChecker().list("FilterImp");
    }
}

