/*
 * Decompiled with CFR 0.152.
 */
package com.chatley.magicbeans;

import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    protected boolean monitorOn = false;
    protected boolean sourceMonitorOn = true;

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.monitor(">> MultiClassLoader.loadClass(" + string + ", " + bl + ")");
        Class<?> clazz = (Class<?>)this.classes.get(string);
        if (clazz != null) {
            this.monitor(">> returning cached result.");
            return clazz;
        }
        try {
            clazz = super.findSystemClass(string);
            this.monitor(">> returning system class (in CLASSPATH).");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.monitor(">> Not a system class.");
            byte[] byArray = this.loadClassBytes(string);
            if (byArray == null) {
                return null;
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            this.classes.put(string, clazz);
            this.monitor(">> Returning newly loaded class.");
            return clazz;
        }
    }

    public void setClassNameReplacementChar(char c) {
        this.classNameReplacementChar = c;
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected String formatClassName(String string) {
        if (this.classNameReplacementChar == '\u0000') {
            return string.replace('.', '/') + ".class";
        }
        return string.replace('.', this.classNameReplacementChar) + ".class";
    }

    protected void monitor(String string) {
        if (this.monitorOn) {
            MultiClassLoader.print(string);
        }
    }

    protected static void print(String string) {
        System.out.println(string);
    }
}

