/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    private static final void getPathComponents(String string, Vector vector) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) continue;
                vector.addElement(string2);
            }
        }
    }

    private static final String getClassPath() {
        Object object;
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("sun.boot.class.path");
        String string3 = System.getProperty("java.ext.dirs");
        Vector<String> vector = new Vector<String>();
        ClassPath.getPathComponents(string, vector);
        ClassPath.getPathComponents(string2, vector);
        Vector vector2 = new Vector();
        ClassPath.getPathComponents(string3, vector2);
        Object object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            object = new File((String)object2.nextElement());
            String[] stringArray = ((File)object).list(new FilenameFilter(){

                public final boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            if (stringArray == null) continue;
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(string3 + File.separatorChar + stringArray[n]);
                ++n;
            }
        }
        object2 = new StringBuffer();
        object = vector.elements();
        while (object.hasMoreElements()) {
            ((StringBuffer)object2).append((String)object.nextElement());
            if (!object.hasMoreElements()) continue;
            ((StringBuffer)object2).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)object2).toString();
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getInputStream();
    }

    public ClassFile getClassFile(String string, String string2) throws IOException {
        int n = 0;
        while (n < this.paths.length) {
            ClassFile classFile = this.paths[n].getClassFile(string, string2);
            if (classFile != null) {
                return classFile;
            }
            ++n;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public ClassFile getClassFile(String string) throws IOException {
        return this.getClassFile(string, ".class");
    }

    public byte[] getBytes(String string, String string2) throws IOException {
        InputStream inputStream = this.getInputStream(string, string2);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string) throws IOException {
        return this.getBytes(string, ".class");
    }

    public String getPath(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getPath();
    }

    public ClassPath(String string) {
        Vector<PathEntry> vector = new Vector<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vector.addElement(new Dir(string2));
                    continue;
                }
                vector.addElement(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[vector.size()];
        vector.copyInto(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    private static abstract class PathEntry {
        abstract ClassFile getClassFile(String var1, String var2) throws IOException;

        PathEntry() {
        }
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();

        public abstract long getTime();

        public abstract long getSize();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        ClassFile getClassFile(String string, String string2) throws IOException {
            File file = new File(this.dir + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return file.exists() ? new ClassFile(this, file){
                private final /* synthetic */ Dir this$0;
                private final /* synthetic */ File val$file;

                public final InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public final String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                public final long getTime() {
                    return this.val$file.lastModified();
                }

                public final long getSize() {
                    return this.val$file.length();
                }
                {
                    this.val$file = file;
                    this.this$0 = dir;
                    this.constructor$0(dir);
                }

                private final void constructor$0(Dir dir) {
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }

        Dir(String string) {
            this.dir = string;
        }
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        ClassFile getClassFile(String string, String string2) throws IOException {
            ZipEntry zipEntry = this.zip.getEntry(string.replace('.', '/') + string2);
            return zipEntry != null ? new ClassFile(this, zipEntry){
                private final /* synthetic */ Zip this$0;
                private final /* synthetic */ ZipEntry val$entry;

                public final InputStream getInputStream() throws IOException {
                    return Zip.access$0(this.this$0).getInputStream(this.val$entry);
                }

                public final String getPath() {
                    return this.val$entry.toString();
                }

                public final long getTime() {
                    return this.val$entry.getTime();
                }

                public final long getSize() {
                    return this.val$entry.getSize();
                }
                {
                    this.val$entry = zipEntry;
                    this.this$0 = zip;
                    this.constructor$0(zip);
                }

                private final void constructor$0(Zip zip) {
                }
            } : null;
        }

        static /* synthetic */ ZipFile access$0(Zip zip) {
            return zip.zip;
        }

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }
    }
}

