/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Node;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Constant
implements Cloneable,
Node {
    protected byte tag;

    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Constants.CONSTANT_NAMES[this.tag] + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static final Constant readConstant(DataInputStream dataInputStream) throws IOException, ClassFormatError {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 7: {
                return new ConstantClass(dataInputStream);
            }
            case 9: {
                return new ConstantFieldref(dataInputStream);
            }
            case 10: {
                return new ConstantMethodref(dataInputStream);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInputStream);
            }
            case 8: {
                return new ConstantString(dataInputStream);
            }
            case 3: {
                return new ConstantInteger(dataInputStream);
            }
            case 4: {
                return new ConstantFloat(dataInputStream);
            }
            case 5: {
                return new ConstantLong(dataInputStream);
            }
            case 6: {
                return new ConstantDouble(dataInputStream);
            }
            case 12: {
                return new ConstantNameAndType(dataInputStream);
            }
            case 1: {
                return new ConstantUtf8(dataInputStream);
            }
        }
        throw new ClassFormatError("Invalid byte tag in constant pool: " + by);
    }

    Constant(byte by) {
        this.tag = by;
    }
}

