/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.FieldOrMethod;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public final void accept(Visitor visitor) {
        visitor.visitMethod(this);
    }

    public final Code getCode() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof Code) {
                return (Code)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        int n = 0;
        while (n < this.attributes_count) {
            if (this.attributes[n] instanceof ExceptionTable) {
                return (ExceptionTable)this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        Object object;
        String string = Utility.accessToString(this.access_flags);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String string2 = constantUtf8.getBytes();
        constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String string3 = constantUtf8.getBytes();
        string2 = Utility.methodSignatureToString(string2, string3, string, true, this.getLocalVariableTable());
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = 0;
        while (n < this.attributes_count) {
            object = this.attributes[n];
            if (!(object instanceof Code) && !(object instanceof ExceptionTable)) {
                stringBuffer.append(" [" + ((Attribute)object).toString() + "]");
            }
            ++n;
        }
        ExceptionTable exceptionTable = this.getExceptionTable();
        if (exceptionTable != null && !((String)(object = exceptionTable.toString())).equals("")) {
            stringBuffer.append("\n\t\tthrows " + (String)object);
        }
        return stringBuffer.toString();
    }

    public final Method copy(ConstantPool constantPool) {
        return (Method)this.copy_(constantPool);
    }

    public Method() {
    }

    public Method(Method method) {
        super(method);
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatError {
        super(dataInputStream, constantPool);
    }

    public Method(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }
}

